/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class CorrespondingBlockNodeCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Corresponding block node consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            boolean isBlockStart = ProcessGraphPredicates.isBlockStart(template, nodeID);
            if (!isBlockStart && !ProcessGraphPredicates.isBlockEnd(template, nodeID)) continue;
            int expectedID = isBlockStart ? ProcessGraphPredicates.join(template, nodeID) : ProcessGraphPredicates.split(template, nodeID);
            if (expectedID == Integer.MIN_VALUE) {
                String message = "No corresponding block node found for node '" + nodeID + "'.";
                if (checkReport != null) {
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "correspondingBlockNode"));
                }
                this.logger.severe(message);
                allOK = false;
                continue;
            }
            int correspondingBlockNodeID = template.getNodeCorrespondingBlockNodeID(nodeID);
            if (correspondingBlockNodeID == expectedID) continue;
            String message = "The corresponding block node of node '" + nodeID + "' is not correct. Expected '" + expectedID + "' - got '" + correspondingBlockNodeID + "'.";
            if (checkReport != null) {
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "correspondingBlockNode"));
            }
            this.logger.severe(message);
            allOK = false;
        }
        if (allOK) {
            this.logger.info("Corresponding block node consistency check. ok.");
        } else {
            this.logger.info("Corresponding block node consistency check. not ok.");
        }
        return allOK;
    }
}

