/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Logger;

public class DataTypeConsistencyCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Data type consistency check";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            if (node.getExecutableBusinessProcess() == null) continue;
            int nodeID = node.getID();
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                if (!this.checkTypeCompatibility(checkReport, template, nodeID, accessType)) {
                    allOK = false;
                }
                ++n2;
            }
        }
        return allOK;
    }

    private boolean checkTypeCompatibility(CheckReport checkReport, Template template, int nodeID, ActivityConstants.AccessType accessType) {
        boolean allOK = true;
        Node node = template.getNode(nodeID);
        int[] nArray = template.getAccessedDataElementIDsForNode(nodeID, accessType);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI[] affectedElements;
            String message;
            int dataElementID = nArray[n2];
            DataElement dataElement = template.getDataElement(dataElementID);
            int connectorID = template.getConnector(nodeID, dataElementID, accessType);
            ProcessModelParameter parameter = ActivityConstants.AccessType.isActivityRelatedValue(accessType) ? node.getExecutableBusinessProcess().getParameter(node.getParameterName(connectorID), accessType) : node.getSystemParameter(node.getParameterName(connectorID), accessType);
            String parameterName = parameter.getName();
            if (parameter.getDataType() != dataElement.getDataType()) {
                allOK = false;
                message = "The ADEPT2 data types of the parameter '" + parameterName + "' and the data element \"" + dataElement.getName() + " (ID " + dataElementID + ")\" do not match at node " + nodeID + ".";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement), ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), parameter)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
            } else if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && !parameter.getUDTName().equals(dataElement.getUDTName())) {
                allOK = false;
                message = "The user defined data types of the parameter '" + parameterName + "' and the data element \"" + dataElement.getName() + " (ID " + dataElementID + ")\" do not match at node " + nodeID + ", parameter type is '" + parameter.getUDTName() + "', data element type is '" + dataElement.getUDTName() + "'.";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement), ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), parameter)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
            }
            UUID parameterIdentifierID = parameter.getIdentifierID();
            UUID dataElementIdentifierID = dataElement.getIdentifierID();
            if (!(dataElementIdentifierID.equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || parameterIdentifierID.equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || parameterIdentifierID.equals(dataElementIdentifierID))) {
                allOK = false;
                String message2 = "The parameter '" + parameterName + "' has the (concrete) identifier ID " + parameterIdentifierID + ", but reads/writes the data element \" " + dataElement.getName() + " (ID " + dataElementID + ")\" with the (concrete) identifier ID " + dataElementIdentifierID + " at node " + nodeID + ".";
                if (checkReport != null) {
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), parameter));
                }
                this.logger.severe(message2);
            }
            ++n2;
        }
        return allOK;
    }
}

