/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.Set;

public class DecisionParameterCheck
implements ProcessTemplateCheck {
    protected static final String CHECK_ID = "Decision node output parameter consistency check.";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean isOK = true;
        block3: for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            switch (template.getNodeType(nodeID)) {
                case NT_XOR_SPLIT: 
                case NT_ENDLOOP: {
                    ProcessModelParameter decisionParameter;
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    if (ebp == null) continue block3;
                    if (!(ebp instanceof DecisionActivity)) {
                        isOK = false;
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "The activity assigned to a decision node is not a decision activity.", affectedElements);
                        break;
                    }
                    DecisionActivity activity = (DecisionActivity)node.getExecutableBusinessProcess();
                    Set<ProcessModelParameter> outParams = activity.getParameters(ActivityConstants.AccessType.WRITE);
                    boolean haveIntParam = false;
                    for (ProcessModelParameter param : outParams) {
                        if (param.getDataType() != ProcessConstants.AdeptDataType.INTEGER || param.isOptional() || param.isVirtual()) continue;
                        haveIntParam = true;
                        break;
                    }
                    if (!haveIntParam) {
                        isOK = false;
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "The decision activity does not have an obligate, non-virtual output parameter of type INTEGER (i.e. no parameter that may be used as a valid decision parameter).", affectedElements);
                    }
                    if ((decisionParameter = activity.getDecisionParameter()) == null) {
                        isOK = false;
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "The decision activity has a null decision parameter.", affectedElements);
                        break;
                    }
                    if (!outParams.contains(decisionParameter)) {
                        isOK = false;
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "The decision activity's decision parameter does not appear in the set of output parameters.", affectedElements);
                    }
                    if (decisionParameter.getDataType() != ProcessConstants.AdeptDataType.INTEGER) {
                        isOK = false;
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "The decision activity's decision parameter is not of type INTEGER.", affectedElements);
                    }
                    if (decisionParameter.isVirtual()) {
                        isOK = false;
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "A decision activity's decision parameter may not be virtual.", affectedElements);
                    }
                    if (!decisionParameter.isOptional()) break;
                    isOK = false;
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "A decision activity's decision parameter must be obligate.", affectedElements);
                    break;
                }
            }
        }
        return isOK;
    }
}

