/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class EdgeAssignmentCheck
implements ProcessTemplateCheck {
    protected static final String GENERAL_ERROR_WHILE_CHECKING_A_NODE = "General error while checking a node:\n";
    protected static final String DECISION_ID_IS_NOT_ASSIGNED_TO_ANY_EDGE = "Decision ID %s is not assigned to any edge.";
    protected static final String EDGE_HAS_NO_DECISION_ID_ASSIGNED = "Edge %s has no decision ID assigned.";
    protected static final String DECISION_ID_ASSIGNED_MULTIPLE_TIMES = "Decision ID %s has been assigned to multiple edges.";
    protected static final String UNKNOWN_DECISION_ID_ASSIGNED = "Edge %s has an unknown decision ID assigned.";
    protected static final String CHECK_ID = "Edge assigment consistency check.";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        HashSet<Long> unassignedIDs = new HashSet<Long>();
        ArrayList<Long> assignedIDs = new ArrayList<Long>();
        ArrayList<Long> allIDs = new ArrayList<Long>();
        boolean result = true;
        for (Node node : template.getNodes()) {
            DecisionActivity activity;
            int nodeID = node.getID();
            if (template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT || node.getExecutableBusinessProcess() == null || !(node.getExecutableBusinessProcess() instanceof DecisionActivity) || (activity = (DecisionActivity)node.getExecutableBusinessProcess()).getType() != EBPType.DECISION_ACTIVITY) continue;
            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "branchID")};
            unassignedIDs.clear();
            try {
                allIDs.clear();
                this.addLongArrayToCollection(activity.getDecisionIDs(), allIDs);
                unassignedIDs.addAll(allIDs);
                int[] nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int succ = nArray[n2];
                    Edge edge = template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL);
                    long edgeCode = edge.getEdgeCode();
                    assignedIDs.clear();
                    this.addLongArrayToCollection(activity.getDecisionID(edgeCode), assignedIDs);
                    if (assignedIDs.size() == 0) {
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, String.format(EDGE_HAS_NO_DECISION_ID_ASSIGNED, edgeCode), affectedElements);
                    } else {
                        if (!unassignedIDs.containsAll(assignedIDs)) {
                            HashSet<Long> doublyAssigned = new HashSet<Long>(assignedIDs);
                            doublyAssigned.removeAll(unassignedIDs);
                            for (Long id : doublyAssigned) {
                                if (allIDs.contains(id)) {
                                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(DECISION_ID_ASSIGNED_MULTIPLE_TIMES, activity.getDecisionLabel(id)), affectedElements);
                                    continue;
                                }
                                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(UNKNOWN_DECISION_ID_ASSIGNED, edgeCode), affectedElements);
                            }
                            result = false;
                        }
                        unassignedIDs.removeAll(assignedIDs);
                    }
                    ++n2;
                }
                if (unassignedIDs.size() <= 0) continue;
                for (Long id : unassignedIDs) {
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(DECISION_ID_IS_NOT_ASSIGNED_TO_ANY_EDGE, activity.getDecisionLabel(id)), affectedElements);
                }
                result = false;
            }
            catch (Exception e) {
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, GENERAL_ERROR_WHILE_CHECKING_A_NODE + e.toString(), affectedElements);
                result = false;
            }
        }
        return result;
    }

    private void addLongArrayToCollection(long[] array, Collection<Long> coll) {
        if (array != null) {
            long[] lArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                long l = lArray[n2];
                coll.add(l);
                ++n2;
            }
        }
    }
}

