/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class EdgeStructureCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Edge structure consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        HashSet<StructuredEdge> edgeStructure = new HashSet<StructuredEdge>(template.getEdgeStructure(new ProcessConstants.EdgeType[0]));
        for (Node node : template.getNodes()) {
            int[] loop_succs;
            int[] sync_succs;
            int[] c_succs;
            int nodeID = node.getID();
            int[] nArray = c_succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
            int n = c_succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                if (!this.findAndRemoveStructuredEdge(template, nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL, edgeStructure, checkReport)) {
                    allOK = false;
                }
                ++n2;
            }
            int[] nArray2 = sync_succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
            int n3 = sync_succs.length;
            n = 0;
            while (n < n3) {
                int succ = nArray2[n];
                if (!this.findAndRemoveStructuredEdge(template, nodeID, succ, ProcessConstants.EdgeType.ET_SYNC, edgeStructure, checkReport)) {
                    allOK = false;
                }
                ++n;
            }
            int[] nArray3 = loop_succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_LOOP);
            int n4 = loop_succs.length;
            n3 = 0;
            while (n3 < n4) {
                int succ = nArray3[n3];
                if (!this.findAndRemoveStructuredEdge(template, nodeID, succ, ProcessConstants.EdgeType.ET_LOOP, edgeStructure, checkReport)) {
                    allOK = false;
                }
                ++n3;
            }
        }
        if (!edgeStructure.isEmpty()) {
            for (StructuredEdge edge : edgeStructure) {
                String message = "The edge '" + edge.getSourceNodeID() + "'-'" + edge.getDestinationNodeID() + "'-'" + (Object)((Object)edge.getEdgeType()) + "' is missing in the edge structure.";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID()), edge.getEdgeType())};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
            }
            allOK = false;
        }
        if (allOK) {
            this.logger.info("Edge structure consistency check. ok.");
        } else {
            this.logger.info("Edge structure consistency check. not ok.");
        }
        return allOK;
    }

    private boolean findAndRemoveStructuredEdge(Template template, int source, int dest, ProcessConstants.EdgeType edgeType, Set<StructuredEdge> structeredEdges, CheckReport checkReport) {
        Iterator<StructuredEdge> i = structeredEdges.iterator();
        while (i.hasNext()) {
            StructuredEdge sEdge = i.next();
            if (sEdge.getSourceNodeID() != source || sEdge.getDestinationNodeID() != dest || !sEdge.getEdgeType().equals((Object)edgeType)) continue;
            Edge edge = template.getEdge(source, dest, edgeType);
            boolean allOK = true;
            if (edge == null) {
                String message = "The edge '" + source + "'-'" + dest + "'-'" + (Object)((Object)edgeType) + "' is in the edge structure, but template.getEdge(...) return null.";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(source), template.getNode(dest), edgeType)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            } else if (edge != sEdge.getEdge()) {
                String message = "The edge '" + source + "'-'" + dest + "'-'" + (Object)((Object)edgeType) + "' is in the edge structure, but template.getEdge(...) return a different reference to an edge object.";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(source), template.getNode(dest), edgeType)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            i.remove();
            return allOK;
        }
        String message = "The edge '" + source + "'-'" + dest + "'-'" + (Object)((Object)edgeType) + "' is missing in the edge structure.";
        if (checkReport != null) {
            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(source), template.getNode(dest), edgeType)};
            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
        }
        this.logger.severe(message);
        return false;
    }
}

