/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;

public class NamingConsistencyCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Naming consistency check";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        HashMap<String, Integer> deNames = new HashMap<String, Integer>();
        for (DataElement dataElement : template.getDataElements()) {
            if (deNames.containsKey(dataElement.getName())) {
                String message = String.format("The data element name '%1$s' is not unique.", dataElement.getName());
                this.logger.info(message);
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), template.getDataElement((Integer)deNames.get(dataElement.getName())))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message, affectedElements);
                }
                allOK = false;
                continue;
            }
            deNames.put(dataElement.getName(), dataElement.getID());
        }
        if (allOK) {
            this.logger.info("Naming consistency check ok.");
        } else {
            this.logger.info("Naming consistency check not ok.");
        }
        return allOK;
    }
}

