/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class NodeInternalConnectorCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Node-internal connector consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            if (node.getExecutableBusinessProcess() == null) continue;
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                if (!this.checkMapping(checkReport, node, accessType)) {
                    allOK = false;
                }
                ++n2;
            }
        }
        return allOK;
    }

    protected boolean checkMapping(CheckReport checkReport, Node node, ActivityConstants.AccessType accessType) {
        URI[] affectedElements;
        String message;
        boolean allOK = true;
        int nodeID = node.getID();
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        Set<ProcessModelParameter> parameters = ActivityConstants.AccessType.isActivityRelatedValue(accessType) ? ebp.getParameters(accessType) : node.getSystemParameters(accessType);
        Map<String, Integer> connectorMapping = node.getConnectorMapping(accessType);
        HashSet<Integer> connectorSet = new HashSet<Integer>(connectorMapping.values());
        if (connectorSet.size() != connectorMapping.values().size()) {
            allOK = false;
            message = "There are duplicate entries in the connector set of node " + nodeID + ", in access type '" + (Object)((Object)accessType) + "'.";
            this.logger.severe(message);
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
        }
        if (parameters.size() != connectorMapping.size()) {
            allOK = false;
            message = "The parameter and connector counts do not match for the access type '" + (Object)((Object)accessType) + "' " + "and the node with ID '" + nodeID + "'. " + "There are " + parameters.size() + " parameters, but " + connectorMapping.size() + " connectors.";
            this.logger.severe(message);
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
        }
        for (ProcessModelParameter parameter : parameters) {
            String name = parameter.getName();
            if (connectorMapping.containsKey(name)) continue;
            allOK = false;
            String message2 = "There is no connector ID for the parameter '" + name + "' from access type '" + (Object)((Object)accessType) + "' at node " + nodeID + ".";
            this.logger.severe(message2);
            if (checkReport == null) continue;
            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, parameter));
        }
        return allOK;
    }
}

