/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class NodeTypeCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Node type consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        URI[] affectedElements;
        String message;
        boolean allOK = true;
        if (!template.getNodeType(template.getStartNode().getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
            message = "The start node is not of type NT_STARTFLOW.";
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getStartNode(), "NodeType")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        if (!template.getNodeType(template.getEndNode().getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
            message = "The end node is not of type NT_ENDFLOW.";
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getEndNode(), "NodeType")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        for (Node node : template.getNodes()) {
            URI[] affectedElements2;
            String message2;
            int nodeID = node.getID();
            ProcessConstants.NodeType type = template.getNodeType(nodeID);
            switch (type) {
                case NT_NORMAL: {
                    if (this.checkOneIn(template, nodeID, checkReport, false) && this.checkOneOut(template, nodeID, checkReport, false)) break;
                    allOK = false;
                    break;
                }
                case NT_ENDFLOW: 
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: 
                case NT_ENDLOOP: {
                    if (this.checkOneIn(template, nodeID, checkReport, false)) break;
                    allOK = false;
                    break;
                }
                case NT_STARTFLOW: 
                case NT_AND_JOIN: 
                case NT_XOR_JOIN: 
                case NT_STARTLOOP: {
                    if (this.checkOneOut(template, nodeID, checkReport, false)) break;
                    allOK = false;
                    break;
                }
                default: {
                    String msg = String.format("Unexpected node type '%s' occurred!", new Object[]{type});
                    this.logger.warning(msg);
                }
            }
            switch (type) {
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: {
                    if (this.checkOneOut(template, nodeID, checkReport, true)) break;
                    allOK = false;
                    break;
                }
                case NT_AND_JOIN: 
                case NT_XOR_JOIN: {
                    if (this.checkOneIn(template, nodeID, checkReport, true)) break;
                    allOK = false;
                    break;
                }
            }
            if (type.equals((Object)ProcessConstants.NodeType.NT_STARTFLOW) && template.getPredByEdgeType(nodeID, new ProcessConstants.EdgeType[0]).length != 0) {
                message2 = "Start node has incoming edges.";
                if (checkReport != null) {
                    affectedElements2 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getStartNode())};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, affectedElements2);
                }
                this.logger.severe(message2);
                allOK = false;
            }
            if (!type.equals((Object)ProcessConstants.NodeType.NT_ENDFLOW) || template.getSuccByEdgeType(nodeID, new ProcessConstants.EdgeType[0]).length == 0) continue;
            message2 = "The end node has outgoing edges.";
            if (checkReport != null) {
                affectedElements2 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getEndNode())};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, affectedElements2);
            }
            this.logger.severe(message2);
            allOK = false;
        }
        if (allOK) {
            this.logger.info("Node type consistency check. ok.");
        } else {
            this.logger.info("Node type consistency check. not ok.");
        }
        return allOK;
    }

    private boolean checkOneIn(Template template, int nodeID, CheckReport checkReport, boolean atLeastOne) {
        int[] preds = template.getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        if (!atLeastOne && preds.length != 1 || preds.length == 0) {
            String atLeast = atLeastOne ? " at least " : " exactly ";
            String message = "The node '" + nodeID + "' is expected to have " + atLeast + " one predecessor but has " + preds.length + ".";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            return false;
        }
        return true;
    }

    private boolean checkOneOut(Template template, int nodeID, CheckReport checkReport, boolean atLeastOne) {
        int[] succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        if (!atLeastOne && succs.length != 1 || succs.length == 0) {
            String atLeast = atLeastOne ? " at least " : " exactly ";
            String message = "The node '" + nodeID + "' is expected to have " + atLeast + " one successor but has " + succs.length + ".";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            return false;
        }
        return true;
    }
}

