/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class SplitNodeCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Split node ID consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            int expectedID = node == template.getStartNode() || node == template.getEndNode() ? Integer.MIN_VALUE : ProcessGraphPredicates.findSplitNode(template, nodeID);
            int nodeSplitNode = template.getNodeSplitNodeID(nodeID);
            if (nodeSplitNode == expectedID) continue;
            String message = "The split node of node '" + nodeID + "' is not correct. Expected '" + expectedID + "' - got '" + nodeSplitNode + "'.";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        if (allOK) {
            this.logger.info("Split node ID consistency check. ok.");
        } else {
            this.logger.info("Split node ID consistency check. not ok.");
        }
        return allOK;
    }
}

