/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class StartEndNodeCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Start / end node consistency check";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        String message;
        boolean allOK = true;
        if (template.getStartNode() == null) {
            message = "The start node is null";
            if (checkReport != null) {
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            this.logger.severe(message);
            allOK = false;
        } else if (template.getNode(template.getStartNode().getID()) != template.getStartNode()) {
            message = "The Node object associated with the ID of the start node, is different from the start node.";
            if (checkReport != null) {
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            this.logger.severe(message);
            allOK = false;
        }
        if (template.getEndNode() == null) {
            message = "The end node is null";
            if (checkReport != null) {
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            this.logger.severe(message);
            allOK = false;
        } else if (template.getNode(template.getEndNode().getID()) != template.getEndNode()) {
            message = "The Node object associated with the ID of the end node, is different from the end node.";
            if (checkReport != null) {
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            this.logger.severe(message);
            allOK = false;
        }
        if (allOK) {
            this.logger.info("Start / end node consistency check ok.");
        } else {
            this.logger.info("Start / end node consistency check not ok.");
        }
        return allOK;
    }
}

