/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class TemplateInputOutputCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Input / output parameter check for templates.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        int[] writtenDataElementsForNode;
        boolean allOK = true;
        Node startNode = template.getStartNode();
        int startNodeID = startNode.getID();
        for (ProcessModelParameter inputParameter : template.getParameters(ActivityConstants.AccessType.READ)) {
            DataElement dataElement;
            int connector = startNode.getConnector(inputParameter.getName(), ActivityConstants.AccessType.WRITE);
            if (connector == Integer.MIN_VALUE) {
                String message = String.format("The template input parameter '%s' is not written to a data element", inputParameter.getName());
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), startNode)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            if ((dataElement = template.getDataElement(startNodeID, connector)) != null) continue;
            allOK = false;
        }
        Node endNode = template.getEndNode();
        int endNodeID = endNode.getID();
        int[] readDataElementsForNode = template.getAccessedDataElementIDsForNode(startNodeID, ActivityConstants.AccessType.READ);
        if (readDataElementsForNode.length > 0) {
            allOK = false;
        }
        if ((writtenDataElementsForNode = template.getAccessedDataElementIDsForNode(endNodeID, ActivityConstants.AccessType.WRITE)).length > 0) {
            allOK = false;
        }
        int[] nArray = template.getAccessedDataElementIDsForNode(startNodeID, ActivityConstants.AccessType.WRITE);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterName;
            int writtenDataElement = nArray[n2];
            int connector = template.getConnector(startNodeID, writtenDataElement, ActivityConstants.AccessType.WRITE);
            if (connector == Integer.MIN_VALUE) {
                allOK = false;
            }
            if ((parameterName = startNode.getParameterName(connector)) == null || !template.getParameters(ActivityConstants.AccessType.READ).contains(parameterName)) {
                String message = String.format("There is no template input parameter for the written data element.", new Object[0]);
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), startNode)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            ++n2;
        }
        return allOK;
    }
}

