/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TemplateInternalConnectorCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Template-internal connector consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            HashSet<Integer> usedConnectorIDs = new HashSet<Integer>();
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                if (!this.checkConnecters(checkReport, template, nodeID, accessType, usedConnectorIDs)) {
                    allOK = false;
                }
                int[] disabledConnectors = template.getDisabledConnectors(nodeID, accessType);
                if (node.getExecutableBusinessProcess() != null) {
                    int[] nArray = disabledConnectors;
                    int n3 = disabledConnectors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int disabledConnectorID = nArray[n4];
                        Map<String, Integer> connectorMapping = node.getConnectorMapping(accessType);
                        if (!connectorMapping.containsValue(disabledConnectorID)) {
                            allOK = false;
                            String message = "A disabled connector ID was found (" + disabledConnectorID + "), which has no corresponding connector ID in the node.";
                            this.logger.severe(message);
                            if (checkReport != null) {
                                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                            }
                        }
                        ++n4;
                    }
                } else if (disabledConnectors.length != 0) {
                    allOK = false;
                    String message = "Disabled connector ID(s) were found, but the node (" + nodeID + ") has no executable business process attached.";
                    this.logger.severe(message);
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                }
                ++n2;
            }
        }
        return allOK;
    }

    private boolean checkConnecters(CheckReport checkReport, Template template, int nodeID, ActivityConstants.AccessType accessType, Set<Integer> usedConnectorIDs) {
        boolean allOK = true;
        int[] disabledConnectors = template.getDisabledConnectors(nodeID, accessType);
        int[] nArray = template.getAccessedDataElementIDsForNode(nodeID, accessType);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int dataElementID = nArray[n2];
            int connectorID = template.getConnector(nodeID, dataElementID, accessType);
            if (usedConnectorIDs.contains(connectorID)) {
                allOK = false;
                String message = "A duplicate connector ID has been found (" + connectorID + ") at node " + nodeID + ".";
                this.logger.severe(message);
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
            }
            usedConnectorIDs.add(connectorID);
            Node node = template.getNode(nodeID);
            if (node.getExecutableBusinessProcess() != null) {
                Map<String, Integer> connectorMapping = node.getConnectorMapping(accessType);
                if (!connectorMapping.containsValue(connectorID)) {
                    allOK = false;
                    String message = "A data edge is connected to a non-existent connector (" + connectorID + ") of node " + nodeID + ".";
                    this.logger.severe(message);
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                }
                int[] nArray2 = disabledConnectors;
                int n3 = disabledConnectors.length;
                int n4 = 0;
                while (n4 < n3) {
                    int disabledConnectorID = nArray2[n4];
                    if (connectorID == disabledConnectorID) {
                        allOK = false;
                        String message = "A data edge was found which is connected to a connector (" + connectorID + ") at node " + nodeID + ", which is marked as disabled.";
                        this.logger.severe(message);
                        if (checkReport != null) {
                            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return allOK;
    }
}

