/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class TopologicalSortingCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Topological sorting";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        int numberOfNodes;
        int endNodeTopoID;
        boolean allOK = true;
        int startNodeTopoID = template.getNodeTopologicalID(template.getStartNode().getID());
        if (startNodeTopoID != 0) {
            String message = "The topological node ID of the start node is not '0' (it's '" + startNodeTopoID + "'.";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getStartNode(), "topologicalID")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        if ((endNodeTopoID = template.getNodeTopologicalID(template.getEndNode().getID())) != (numberOfNodes = template.getNodes().size() - 1)) {
            String message = "The topological node ID of the end node does not match the amount of nodes - 1 ('" + numberOfNodes + "') (it's '" + endNodeTopoID + "'.";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getEndNode(), "topologicalID")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        for (Node node : template.getNodes()) {
            int[] succs;
            int nodeID = node.getID();
            int topoID = template.getNodeTopologicalID(nodeID);
            int[] nArray = succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
            int n = succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                int succTopoID = template.getNodeTopologicalID(succ);
                if (succTopoID <= topoID) {
                    String message = "The topological node ID of a successor of the node with the (static) ID '" + nodeID + "' is wrong, the topological ID of the node is '" + topoID + "'; successor static ID:'" + succ + "' - topo ID:'" + succTopoID + "'.";
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(succ), "topologicalID")};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    this.logger.severe(message);
                    allOK = false;
                }
                ++n2;
            }
        }
        if (allOK) {
            this.logger.info("Topological sorting ok.");
        } else {
            this.logger.info("Topological sorting not ok.");
        }
        return allOK;
    }
}

