/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ConnectorCheck
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final String ID = "Connector check";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                int[] unconnectedConnectors = template.getUnconnectedConnectors(nodeID, accessType);
                if (unconnectedConnectors.length > 0) {
                    ArrayList<String> unconnectedParameters = new ArrayList<String>();
                    int[] nArray = unconnectedConnectors;
                    int n3 = unconnectedConnectors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int connectorID = nArray[n4];
                        unconnectedParameters.add(node.getParameterName(connectorID));
                        ++n4;
                    }
                    allOK = false;
                    String message = "The node '%s' (#%d) has unconnected parameters for access '%s': %s";
                    message = String.format(message, new Object[]{node.getName(), node.getID(), accessType, StringTools.join(", ", StringTools.surround("'", "'", unconnectedParameters))});
                    this.logger.info(message);
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(ID, CheckReport.ResultType.WARNING, message, affectedElements);
                    }
                }
                ++n2;
            }
        }
        return allOK;
    }
}

