/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.SystemDataConsumer;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsumerVariableCheck
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final String ID = "Consumer Variable check";
    private static final List<Class<?>> consumerClasses = Arrays.asList(Template.class, Node.class);
    private final ProcessModelFactory pmf;

    public ConsumerVariableCheck(ProcessModelFactory pmf) {
        this.pmf = pmf;
    }

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Class<?> consumerClass : consumerClasses) {
            Set<Object> objects = this.getObjectsForConsumerClass(consumerClass, template);
            Method[] methodArray = consumerClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                SystemDataConsumer annotation = method.getAnnotation(SystemDataConsumer.class);
                if (annotation != null) {
                    for (Object o : objects) {
                        Object res;
                        if (method.getParameterTypes().length > 0) continue;
                        try {
                            res = method.invoke(o, new Object[0]);
                        }
                        catch (IllegalArgumentException e) {
                            allOK = false;
                            this.handleReflectionException(method, e);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            allOK = false;
                            this.handleReflectionException(method, e);
                            continue;
                        }
                        catch (InvocationTargetException e) {
                            allOK = false;
                            this.handleReflectionException(method, e);
                            continue;
                        }
                        catch (ClassCastException e) {
                            allOK = false;
                            this.handleReflectionException(method, e);
                            continue;
                        }
                        if (res == null) continue;
                        Set<ProcessModelParameter> parameters = this.getParameters(o, method);
                        if (res instanceof String) {
                            String paramString = (String)res;
                            ParameterRef[] paramRefs = SystemDataTools.findParameterReferences(paramString);
                            allOK &= this.checkParameterRefs(checkReport, o, parameters, paramRefs);
                            continue;
                        }
                        if (res instanceof Map) {
                            Map pluginDataMap = (Map)res;
                            for (PluginData entry : pluginDataMap.values()) {
                                for (String paramString : entry.getPluginData().values()) {
                                    if (paramString == null) continue;
                                    ParameterRef[] paramRefs = SystemDataTools.findParameterReferences(paramString);
                                    allOK = this.checkParameterRefs(checkReport, o, parameters, paramRefs);
                                }
                            }
                            continue;
                        }
                        throw new AssertionError((Object)("Unknown return type for a SystemDataConsumer: " + res.getClass()));
                    }
                }
                ++n2;
            }
        }
        return allOK;
    }

    private boolean checkParameterRefs(CheckReport checkReport, Object o, Set<ProcessModelParameter> parameters, ParameterRef[] paramRefs) {
        boolean allOK = true;
        ParameterRef[] parameterRefArray = paramRefs;
        int n = paramRefs.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                ParameterRef paramRef = parameterRefArray[n2];
                for (ProcessModelParameter parameter : parameters) {
                    if (!SystemDataTools.isCompatibleParameter(paramRef, parameter)) {
                        continue;
                    }
                    break block4;
                }
                allOK = false;
                String msg = "The parameter refered to in the parameter reference %s does not exist!";
                msg = String.format(msg, paramRef);
                if (checkReport != null) {
                    URI affectedElement = this.getAffectedElementForObject(checkReport.getBase(), o);
                    checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, msg, affectedElement);
                }
                this.logger.info(msg);
            }
            ++n2;
        }
        return allOK;
    }

    private void handleReflectionException(Method method, Exception e) {
        String message = String.format("An exception ocurred while calling the method %s#%s(): %s.", method.getDeclaringClass(), method.getName(), e.getMessage());
        this.logger.log(Level.SEVERE, message, e);
    }

    private Set<Object> getObjectsForConsumerClass(Class<?> consumerClass, Template template) {
        HashSet<Object> objects = new HashSet<Object>();
        if (consumerClass == Template.class) {
            objects.add(template);
        } else if (consumerClass == Node.class) {
            objects.addAll(template.getNodes());
        } else {
            String message = String.format("Unknown consumer class %s.", consumerClass);
            this.logger.severe(message);
            assert (false) : message;
        }
        return objects;
    }

    private Set<ProcessModelParameter> getParameters(Object o, Method method) {
        HashSet<ProcessModelParameter> parameters = new HashSet<ProcessModelParameter>();
        if (o instanceof Template) {
            Template template = (Template)o;
            if (method.getName().equals("getInstanceNameTemplate") || method.getName().equals("getPluginDatas")) {
                for (DataElement dataElement : template.getDataElements()) {
                    if (dataElement.getName().equals("")) continue;
                    ProcessConstants.AdeptDataType dataType = dataElement.getDataType();
                    String udtName = dataElement.getUDTName();
                    if (dataType != ProcessConstants.AdeptDataType.USERDEFINED) {
                        udtName = null;
                    }
                    parameters.add(this.pmf.createProcessModelParameter(dataElement.getName(), dataElement.getDescription(), dataType, udtName, dataElement.getIdentifierID(), false, dataElement.isVirtual(), false, null, null, null, null));
                }
            } else {
                parameters.addAll(template.getParameters(ActivityConstants.AccessType.READ));
            }
        } else if (o instanceof Node) {
            parameters.addAll(((Node)o).getSystemParameters(ActivityConstants.AccessType.SYSTEM_READ));
        } else {
            String message = String.format("Unknown consumer class %s.", o.getClass());
            this.logger.severe(message);
            assert (false) : message;
        }
        return parameters;
    }

    private URI getAffectedElementForObject(URI base, Object o) {
        if (o instanceof Template) {
            return base;
        }
        if (o instanceof Node) {
            return ProcessElementIdentifierTools.getNodeIdentifier(base, (Node)o);
        }
        String message = String.format("Unknown consumer class %s.", o.getClass());
        this.logger.severe(message);
        assert (false) : message;
        return base;
    }
}

