/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class DisabledNonOptionalParameterCheck
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final String ID = "Disabled non optional parameter check";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            if (node.getExecutableBusinessProcess() == null) continue;
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                int[] nArray = template.getDisabledConnectors(node.getID(), accessType);
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int disabledDC = nArray[n4];
                    String parameterName = node.getParameterName(disabledDC);
                    ProcessModelParameter parameter = node.getExecutableBusinessProcess().getParameter(parameterName, accessType);
                    if (!parameter.isOptional()) {
                        switch (accessType) {
                            case READ: {
                                String message = String.format("The node #%s has a disabled input parameter ('%s'), but the parameter is non-optional!", Integer.toString(node.getID()), parameterName);
                                this.logger.severe(message);
                                if (checkReport != null) {
                                    checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), parameter));
                                }
                                allOK = false;
                                break;
                            }
                            case WRITE: {
                                String message = String.format("The node #%s has a disabled output parameter ('%s'), but the parameter is non-optional!", Integer.toString(node.getID()), parameterName);
                                this.logger.info(message);
                                if (checkReport != null) {
                                    checkReport.addReportEntry(ID, CheckReport.ResultType.INFO, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), parameter));
                                }
                                allOK = true;
                                break;
                            }
                            default: {
                                String message = String.format("The node #%s has a disabled parameter ('%s') of unknown access type!", Integer.toString(node.getID()), parameterName);
                                this.logger.severe(message);
                                if (checkReport != null) {
                                    checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), parameter));
                                }
                                allOK = false;
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return allOK;
    }
}

