/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.dataflow.DataFlowTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;

public class NoParallelWriterExistsCheck
implements ProcessTemplateCheck {
    public static final String REPORT_ENTRY_TYPE = "NoParallelWriterExistsCheck";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (DataElement dataElement : template.getDataElements()) {
            int[] writingNodes = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.WRITE);
            for (int accessorID : DataFlowTools.getAllAccessors(template, dataElement.getID())) {
                int[] nArray = writingNodes;
                int n = writingNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeRelations.NodeRelation relation;
                    int writerID = nArray[n2];
                    if (accessorID != writerID && (relation = relations.getNodeRelation(accessorID, writerID)).equals((Object)NodeRelations.NodeRelation.PARALLEL)) {
                        allOK = false;
                        if (checkReport != null) {
                            Node accessor = template.getNode(accessorID);
                            Node writer = template.getNode(writerID);
                            String message = "Data element '" + dataElement.getName() + "' is written by node '" + writer.getName() + " (" + writerID + ")' while being accessed by node '" + accessor.getName() + "' (" + accessorID + ") in parallel!";
                            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), writer), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), accessor)};
                            checkReport.addReportEntry(REPORT_ENTRY_TYPE, CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                    }
                    ++n2;
                }
            }
        }
        return allOK;
    }
}

