/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class PublicDataElementCheck
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final String ID = "Public Data Element Check";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (DataElement dataElement : template.getDataElements()) {
            if (!dataElement.isPublic() || dataElement.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) continue;
            allOK = false;
            String message = String.format("The data element '%s' (%s) is public, but it is not allowed to be public since it is is of type %s.", new Object[]{dataElement.getName(), dataElement.getID(), ProcessConstants.AdeptDataType.USERDEFINED});
            this.logger.info(message);
            if (checkReport == null) continue;
            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement)};
            checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, affectedElements);
        }
        return allOK;
    }
}

