/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.AbstractProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.util.CheckReport;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SystemDataProducerCheck
extends AbstractProcessTemplateCheck {
    private static final String ID = "Consumer Variable check";

    public SystemDataProducerCheck() {
        super(ID);
    }

    @Override
    public void performCheckSpi(Template template, NodeRelations relations, CheckReport checkReport) {
        Set<ProcessModelParameter> processInput = template.getParameters(ActivityConstants.AccessType.READ);
        HashSet<String> processInputNames = new HashSet<String>();
        for (ProcessModelParameter p : processInput) {
            processInputNames.add(p.getName());
        }
        HashSet<ProcessModelParameter> systemParameters = new HashSet<ProcessModelParameter>(template.getStartNode().getSystemParameters(ActivityConstants.AccessType.SYSTEM_WRITE));
        Iterator i = systemParameters.iterator();
        while (i.hasNext()) {
            ProcessModelParameter parameter = (ProcessModelParameter)i.next();
            if (!processInputNames.contains(parameter.getName())) continue;
            i.remove();
        }
        for (ProcessModelParameter p : systemParameters) {
            String message;
            SystemDataProducer producer = SystemDataProducer.getProducerForIdentifierID(p.getIdentifierID());
            if (producer == null) {
                message = String.format("The start node has an output parameter ('%s') which is not a process input parameter and not a system data producer.", p.getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message, template.getStartNode());
                continue;
            }
            if (producer.name().startsWith("TEMPLATE") || producer.name().startsWith("INSTANCE")) continue;
            message = String.format("The start node has an system data producer parameter ('%s') which is not a system data producer of the template / instance (%s).", p.getName(), producer.name());
            this.addReportEntry(CheckReport.ResultType.FAILURE, message, template.getStartNode());
        }
        for (Node node : template.getNodes()) {
            if (node.getID() == template.getEndNode().getID() || node.getID() == template.getStartNode().getID()) continue;
            for (ProcessModelParameter p : node.getSystemParameters(ActivityConstants.AccessType.SYSTEM_WRITE)) {
                String message;
                SystemDataProducer producer = SystemDataProducer.getProducerForIdentifierID(p.getIdentifierID());
                if (producer == null) {
                    message = String.format("The node '%s' has a system output parameter ('%s') which is not a system data producer.", node.getName(), p.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, message, template.getStartNode());
                    continue;
                }
                if (producer.name().startsWith("NODE")) continue;
                message = String.format("The node '%s' has a system output parameter ('%s') which is not a system data producer of a node (%s).", node.getName(), p.getName(), producer.name());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message, template.getStartNode());
            }
        }
    }
}

