/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;

public class UserDefinedTypeCheck
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final String ID = "User Defined Types check";

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (DataElement dataElement : template.getDataElements()) {
            if (dataElement.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) continue;
            allOK &= this.checkUserDefinedTypeName(dataElement.getName(), dataElement.getUDTName(), checkReport, null, dataElement);
        }
        for (Node node : template.getNodes()) {
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp == null) continue;
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                Set<ProcessModelParameter> parameters = ActivityConstants.AccessType.isActivityRelatedValue(accessType) ? ebp.getParameters(accessType) : node.getSystemParameters(accessType);
                for (ProcessModelParameter parameter : parameters) {
                    if (parameter.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) continue;
                    allOK &= this.checkUserDefinedTypeName(parameter.getName(), parameter.getUDTName(), checkReport, node, null);
                }
                ++n2;
            }
        }
        return allOK;
    }

    protected boolean checkUserDefinedTypeName(String name, String udtName, CheckReport checkReport, Node node, DataElement dataElement) {
        if (udtName == null || udtName.equals("")) {
            String message = node != null ? String.format("The parameter '%s' of node %s is of type USERDEFINED, but has no UDT name.", name, node.getID()) : String.format("The data element '%s' (%s) is of type USERDEFINED, but has no UDT name.", name, dataElement.getID());
            this.logger.info(message);
            if (checkReport != null) {
                URI[] affectedElements = node != null ? new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)} : new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement)};
                checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }
}

