/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.dataflow;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.logging.Logger;

public class WriterExistsCheck
implements ProcessTemplateCheck {
    private static final String REPORT_ENTRY_TYPE = "WriterExistsCheck";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (DataElement dataElement : template.getDataElements()) {
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.dataFlowReadAccess();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType readAccessType = accessTypeArray[n2];
                int[] nArray = template.getAccessingNodeIDsForDataElement(dataElement.getID(), readAccessType);
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int readerID = nArray[n4];
                    boolean optionalReader = template.getDataEdge(readerID, dataElement.getID(), readAccessType).isOptional();
                    boolean writerBeforeReader = false;
                    HashSet<Integer> optionalWriters = new HashSet<Integer>();
                    ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.dataFlowWriteAccess();
                    int n5 = accessTypeArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ActivityConstants.AccessType writeAccessType = accessTypeArray2[n6];
                        int[] nArray2 = template.getAccessingNodeIDsForDataElement(dataElement.getID(), writeAccessType);
                        int n7 = nArray2.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            int writerID = nArray2[n8];
                            if (writerID != readerID) {
                                DataEdge dataEdge = template.getDataEdge(writerID, dataElement.getID(), writeAccessType);
                                if (dataEdge.isOptional()) {
                                    this.logger.fine(String.format("Ignoring writing node %s because of optional write access", writerID));
                                } else {
                                    NodeRelations.NodeRelation relation = relations.getNodeRelation(writerID, readerID);
                                    switch (relation) {
                                        case ONE_BEFORE_TWO: 
                                        case ONE_BEFORE_TWO_OPTIONAL: {
                                            writerBeforeReader = true;
                                            break;
                                        }
                                        case ONE_OPTIONAL_BEFORE_TWO: 
                                        case ONE_OPTIONAL_BEFORE_TWO_OPTIONAL: {
                                            this.logger.info("Adding optional writer " + writerID);
                                            optionalWriters.add(writerID);
                                            break;
                                        }
                                        default: {
                                            String msg = String.format("Nonrelevant relation '%s' found!", new Object[]{relation});
                                            this.logger.finest(msg);
                                        }
                                    }
                                    if (writerBeforeReader) break;
                                }
                            }
                            ++n8;
                        }
                        ++n6;
                    }
                    if (relations.atLeastOneIsExecutedBefore(optionalWriters, readerID)) {
                        this.logger.info("supplied by optional writers.");
                        writerBeforeReader = true;
                    }
                    if (!writerBeforeReader) {
                        if (!optionalReader) {
                            allOK = false;
                        }
                        if (checkReport != null) {
                            String message;
                            Node reader = template.getNode(readerID);
                            URI base = checkReport.getBase();
                            URI[] affectedElements = new URI[]{};
                            if (base != null) {
                                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(base, reader), ProcessElementIdentifierTools.getDataElementIdentifier(base, dataElement)};
                            }
                            if (!optionalReader) {
                                message = "Data element '" + dataElement.getName() + "' is not supplied at the read access of node '" + reader.getName() + "' (" + reader.getID() + ")!";
                                checkReport.addReportEntry(REPORT_ENTRY_TYPE, CheckReport.ResultType.FAILURE, message, affectedElements);
                            } else {
                                message = "Data element '" + dataElement.getName() + "' might not be supplied at the optional read access of node '" + reader.getName() + "' (" + reader.getID() + ")!";
                                checkReport.addReportEntry(REPORT_ENTRY_TYPE, CheckReport.ResultType.INFO, message, affectedElements);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return allOK;
    }
}

