/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.other;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.logging.Logger;

public class EdgeCodeCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Edge Code Check";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        HashSet<Long> usedEdgeCodes = new HashSet<Long>();
        for (Node node : template.getNodes()) {
            int[] succs;
            int nodeID = node.getID();
            if (template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT) continue;
            usedEdgeCodes.clear();
            int[] nArray = succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
            int n = succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                Edge edge = template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL);
                if (!usedEdgeCodes.add(edge.getEdgeCode())) {
                    String message = String.format("The edge code of edge between nodes %s-%s is not unique!", nodeID, succ);
                    this.logger.info(message);
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), node, template.getNode(succ), edge.getType())};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message, affectedElements);
                    }
                    allOK = false;
                }
                ++n2;
            }
        }
        return allOK;
    }
}

