/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.other;

import de.aristaflow.adept2.model.common.plugindata.ErrorHandlingProcessData;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.ContainsFilter;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class ErrorHandlingFilters {
    public static Filter getTemplateStatusFilter(FilterFactory filterFactory) {
        AttributeFactory statusAF = filterFactory.createAttributeFactory(TemplateStatus.class);
        ArrayList<ComparisonFilter> filterList = new ArrayList<ComparisonFilter>();
        filterList.add(filterFactory.createComparisonFilter(statusAF.selectAttribute("isTopLevelUsable"), ComparisonOperator.EQUALS, Boolean.valueOf(true)));
        filterList.add(filterFactory.createComparisonFilter(statusAF.selectAttribute("isOutdated", Boolean.valueOf(false)), ComparisonOperator.EQUALS, Boolean.valueOf(false)));
        filterList.add(filterFactory.createComparisonFilter(statusAF.selectAttribute("isInstantiable", Boolean.valueOf(false)), ComparisonOperator.EQUALS, Boolean.valueOf(true)));
        filterList.add(filterFactory.createComparisonFilter(statusAF.selectAttribute("getBuildtimeState"), ComparisonOperator.EQUALS, (Comparable<?>)((Object)ProcessConstants.TemplateBuildtimeState.RELEASED)));
        return filterFactory.createAndFilter(filterList.toArray(new Filter[filterList.size()]));
    }

    public static Filter getTemplateFilter(FilterFactory filterFactory) {
        AttributeFactory templateAF = filterFactory.createAttributeFactory(Template.class);
        AttributeFactory paramAF = templateAF.getFactoryForCollectionAttribute("getParameters");
        Attribute dataTypeAttrib = paramAF.selectAttribute("getDataType");
        Attribute nameAttrib = paramAF.selectAttribute("getName");
        Attribute isOptionalAttrib = paramAF.selectAttribute("isOptional");
        Attribute readParamsAttr = templateAF.selectAttribute("getParameters", new Serializable[]{ActivityConstants.AccessType.READ});
        HashMap<ProcessConstants.AdeptDataType, ComparisonFilter> isTypeFilters = new HashMap<ProcessConstants.AdeptDataType, ComparisonFilter>();
        ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
        int n = adeptDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.AdeptDataType type = adeptDataTypeArray[n2];
            ComparisonFilter typeIsFilter = filterFactory.createComparisonFilter(dataTypeAttrib, ComparisonOperator.EQUALS, (Comparable<?>)((Object)type));
            isTypeFilters.put(type, typeIsFilter);
            ++n2;
        }
        LinkedList<ContainsFilter> parameterFilterList = new LinkedList<ContainsFilter>();
        ErrorHandlingProcessData.ErrorHandlingParameter[] errorHandlingParameterArray = ErrorHandlingProcessData.ErrorHandlingParameter.values();
        int n3 = errorHandlingParameterArray.length;
        n = 0;
        while (n < n3) {
            ErrorHandlingProcessData.ErrorHandlingParameter param = errorHandlingParameterArray[n];
            ComparisonFilter nameIsFilter = filterFactory.createComparisonFilter(nameAttrib, ComparisonOperator.EQUALS, (Comparable<?>)((Object)param.parameterName));
            ComparisonFilter isOptionalFilter = filterFactory.createComparisonFilter(isOptionalAttrib, ComparisonOperator.EQUALS, Boolean.valueOf(param.isOptional));
            Filter typeFilter = (Filter)isTypeFilters.get((Object)param.dataType);
            MultipleFilterFilter nameAndTypeFilter = filterFactory.createAndFilter(nameIsFilter, typeFilter, isOptionalFilter);
            ContainsFilter paramFilter = filterFactory.createContainsAnyFilter(readParamsAttr, nameAndTypeFilter);
            parameterFilterList.add(paramFilter);
            ++n;
        }
        return filterFactory.createAndFilter(parameterFilterList.toArray(new Filter[parameterFilterList.size()]));
    }
}

