/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.other;

import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class NodeAutoStartCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Node Auto Start Check";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            URI[] affectedElements;
            if (!node.isAutoStartEnabled()) continue;
            String message = String.format("The auto start of node '%s' is enabled, i.e. the activity will be started automatically after the confirmation of the related predecessor activity.", String.valueOf(node.getName()) + " (ID = " + node.getID() + ")");
            this.logger.info(message);
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "autoStart")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.INFO, message, affectedElements);
                if (node.getExecutableBusinessProcess() != null && !node.getExecutableBusinessProcess().getExecutionControlProperties().isSuspensible()) {
                    message = String.format("The node '%s' is not suspensible, i.e. it must be executed at once. Is the auto start correct here?", String.valueOf(node.getName()) + " (ID = " + node.getID() + ")");
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.INFO, message, affectedElements);
                }
            }
            if (UpdateNode.autoStartEnabled(template, node)) continue;
            message = String.format("The previous setting of auto start for the node '%s' is no longer valid!", String.valueOf(node.getName()) + " (ID = " + node.getID() + ")");
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "autoStart")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            allOK = false;
        }
        return allOK;
    }
}

