/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.other;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class ParameterConfigurationCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Parameter Configuration Check";
    private final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        String msg = "The template parameter '%s' has an empty configuration key!";
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType type = accessTypeArray[n2];
            for (ProcessModelParameter p : template.getParameters(type)) {
                this.checkParameter(p, checkReport, msg, null);
            }
            ++n2;
        }
        for (Node n3 : template.getNodes()) {
            ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.systemRelatedValues();
            int n4 = accessTypeArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                ActivityConstants.AccessType type = accessTypeArray2[n5];
                for (ProcessModelParameter p : n3.getSystemParameters(type)) {
                    msg = "The node parameter '%s' has an empty configuration key!";
                    this.checkParameter(p, checkReport, msg, null);
                }
                ++n5;
            }
            accessTypeArray2 = ActivityConstants.AccessType.activityRelatedValues();
            n4 = accessTypeArray2.length;
            n5 = 0;
            while (n5 < n4) {
                ActivityConstants.AccessType type = accessTypeArray2[n5];
                if (n3.getExecutableBusinessProcess() != null) {
                    for (ProcessModelParameter p : n3.getExecutableBusinessProcess().getParameters(type)) {
                        msg = "The EBP parameter '%s' has an empty configuration key!";
                        this.checkParameter(p, checkReport, msg, n3);
                    }
                }
                ++n5;
            }
        }
        return true;
    }

    private void checkParameter(ProcessModelParameter param, CheckReport checkReport, String baseMsg, Node node) {
        if (param.getConfiguration().getAllEntries().contains("")) {
            String msg = String.format(baseMsg, param.getName());
            if (checkReport != null) {
                URI uri = null;
                if (node != null) {
                    uri = ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, node.getExecutableBusinessProcess(), param);
                }
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, msg, uri);
            } else {
                this.logger.warning(msg);
            }
        }
    }
}

