/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.other;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.common.plugindata.EscalationData;
import de.aristaflow.adept2.model.common.plugindata.SchedulerData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.common.viewer.UnresolvedParameterReferenceException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.time.DateTimeFormat;
import java.net.URI;
import java.util.logging.Logger;

public class TimeDataCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Time Data Check";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            if (this.checkNode(node, template, relations, checkReport)) continue;
            allOK = false;
        }
        return allOK;
    }

    public boolean checkNode(Node node, Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        URI[] affectedElements = null;
        if (checkReport != null) {
            affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
        }
        long activationDate = 0L;
        long dueDate = 0L;
        SchedulerData schedData = null;
        if (node.getPluginData("SchedulerData") != null) {
            long bufferTime;
            String dueDateString;
            schedData = ModelViewer.createView(node.getPluginData("SchedulerData").getPluginData(), SchedulerData.class);
            try {
                dueDate = schedData.getDueDate();
            }
            catch (UnresolvedParameterReferenceException unresolvedParameterReferenceException) {}
            if (dueDate < 0L) {
                dueDate = activationDate + -dueDate;
                dueDateString = DateTimeFormat.formatTime(dueDate);
            } else {
                dueDateString = DateTimeFormat.formatDate(dueDate);
            }
            if (dueDate != 0L && schedData.getComplexity() != 0L && (bufferTime = dueDate - (activationDate + schedData.getComplexity())) <= 0L) {
                allOK = false;
                String message = String.format("The expenditure of time (%s) of the node '%s' (%s) exceeds the node's due date (%s) by %s.", DateTimeFormat.formatTime(schedData.getComplexity()), node.getName(), node.getID(), dueDateString, DateTimeFormat.formatTime(-bufferTime));
                this.logger.info(message);
                if (checkReport != null) {
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message, affectedElements);
                }
            }
        }
        if (node.getPluginData("EscalationData") != null) {
            EscalationData escData = ModelViewer.createView(node.getPluginData("EscalationData").getPluginData(), EscalationData.class);
            if (schedData != null && dueDate != 0L && escData.getEscalationDate() != 0L) {
                String message;
                long escalation = escData.getEscalationDate();
                String escalationString = DateTimeFormat.formatDateTime(escalation);
                String dueDateString = DateTimeFormat.formatDateTime(dueDate);
                if (dueDate < 0L && escalation > 0L || dueDate > 0L && escalation < 0L) {
                    message = String.format("The escalation date and the due date have mixed reference points (relative / absolute) (node '%s' (%s)).", node.getName(), node.getID());
                    this.logger.info(message);
                    if (checkReport != null) {
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.INFO, message, affectedElements);
                    }
                } else {
                    boolean escalationOK = true;
                    if (dueDate < 0L && escalation < dueDate) {
                        escalationOK = false;
                    } else if (dueDate > 0L && escalation > dueDate) {
                        escalationOK = false;
                    }
                    if (!escalationOK) {
                        allOK = false;
                        String message2 = String.format("The first escalation happens in %s but the due is set to %s in node '%s' (%s)", escalationString, dueDateString, node.getName(), node.getID());
                        this.logger.info(message2);
                        if (checkReport != null) {
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.INFO, message2, affectedElements);
                        }
                    }
                }
                if ("MultiLevelEscalationHandling".equals(escData.getEscalationHandlingProcedureID()) && node.getPluginData("MultiLevelEscalationHandling") == null) {
                    allOK = false;
                    message = String.format("The escalation is set to multi-level escalation, but there is not escalation specified in node '%s' (%s).", node.getName(), node.getID());
                    this.logger.info(message);
                    if (checkReport != null) {
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.INFO, message, affectedElements);
                    }
                }
            } else {
                escData.getEscalationDate();
            }
        } else if (schedData != null) {
            // empty if block
        }
        return allOK;
    }
}

