/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.other;

import de.aristaflow.adept2.core.checks.processmodel.AbstractProcessTemplateCheck;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.SystemDataConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.util.CheckReport;
import java.util.EnumSet;

public class UserInstantiationCheck
extends AbstractProcessTemplateCheck {
    private static final String CHECK_ID = "User Instantiation Check";

    public UserInstantiationCheck() {
        super(CHECK_ID);
    }

    @Override
    public void performCheckSpi(Template template, NodeRelations relations, CheckReport checkReport) {
        if (checkReport == null) {
            return;
        }
        boolean autoStartForInitiator = false;
        Node firstInitiatorNode = null;
        for (DataElement dataElement : template.getDataElements()) {
            int[] nodeIDs;
            if (!dataElement.getIdentifierID().equals(SystemDataConstants.IDENTIFIER_ID_INSTANCE_INITIATOR_AGENT) && !dataElement.getIdentifierID().equals(SystemDataConstants.IDENTIFIER_ID_INSTANCE_INITIATOR_ORGPOSITION)) continue;
            int[] nArray = nodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ);
            int n = nodeIDs.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeID = nArray[n2];
                Node node = template.getNode(nodeID);
                String sar = node.getStaffAssignmentRule();
                ParameterRef[] refs = ParameterRefTools.findParameterReferences(sar, EnumSet.of(ProcessConstants.AdeptDataType.INTEGER));
                if (refs.length > 0) {
                    if (firstInitiatorNode == null || template.getNodeTopologicalID(nodeID) < template.getNodeTopologicalID(firstInitiatorNode.getID())) {
                        firstInitiatorNode = node;
                    }
                    if (node.isAutoStartEnabled()) {
                        autoStartForInitiator = true;
                    }
                }
                ++n2;
            }
        }
        if (template.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            boolean optional = true;
            for (ProcessModelParameter param : template.getParameters(ActivityConstants.AccessType.READ)) {
                boolean bl = optional = optional && param.isOptional();
            }
            if (!optional) {
                String msg = "The process has mandatory input parameters, i.e. it currently can't be started in the regular AristaFlow Client.";
                this.addReportEntry(CheckReport.ResultType.INFO, msg, new Object[0]);
            }
        } else if (!autoStartForInitiator) {
            Object[] elements;
            String message;
            if (firstInitiatorNode == null) {
                message = String.format("The process has no input parameters, if it is intended to be started by a user, consider enabling the autostart on the first activity intended to be opened for the starter of the instance.", new Object[0]);
                elements = new Object[]{};
            } else {
                message = String.format("The process has no input parameters, if it is intended to be started by a user, consider enabling the autostart on the first activity intended to be opened for the starter of the instance, e.g. on node '%s' (%s).", firstInitiatorNode.getName(), firstInitiatorNode.getID());
                elements = new Object[]{firstInitiatorNode};
            }
            this.addReportEntry(CheckReport.ResultType.INFO, message, elements);
        }
    }
}

