/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.AbstractProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.HashSet;

public class CF1Check
extends AbstractProcessTemplateCheck {
    private static final String ID = "Constraint Flow Check No.1";
    private final CheckReport.ResultType LogLevelEnteringLeavingLoop = CheckReport.ResultType.WARNING;

    public CF1Check() {
        super(ID);
    }

    @Override
    protected void performCheckSpi(Template template, NodeRelations relations, CheckReport checkReport) {
        for (StructuredConstraintEdge constraintEdge : template.getConstraintEdgeStructure()) {
            int sourceNodeID = constraintEdge.getSourceNodeID();
            int destinationNodeID = constraintEdge.getDestinationNodeID();
            this.constraintEdgeValid(template, relations, checkReport, sourceNodeID, destinationNodeID);
        }
    }

    public boolean constraintEdgeValid(Template template, NodeRelations relations, CheckReport checkReport, int sourceNodeID, int destinationNodeID) {
        NodeRelations.NodeRelation nodeRelation = relations.getNodeRelation(sourceNodeID, destinationNodeID);
        if (NodeRelations.NodeRelation.EXCLUSIVE.equals((Object)nodeRelation)) {
            Node start = template.getNode(sourceNodeID);
            Node destination = template.getNode(destinationNodeID);
            URI affectedElements = ProcessElementIdentifierTools.getConstraintEdgeIdentifier(checkReport.getBase(), start, destination);
            this.addReportEntry(CheckReport.ResultType.FAILURE, "Constraint edge cannot connect two elements which are executed exclusive!", affectedElements);
            return false;
        }
        if (NodeRelations.NodeRelation.AFTER.equals((Object)nodeRelation)) {
            Node start = template.getNode(sourceNodeID);
            Node destination = template.getNode(destinationNodeID);
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(start);
            nodes.add(destination);
            int[] minBlock = template.getMinBlock(nodes);
            int splitNode = minBlock[0];
            ProcessConstants.NodeType split = template.getNodeType(splitNode);
            while (!ProcessConstants.NodeType.NT_STARTLOOP.equals((Object)split) && !ProcessConstants.NodeType.NT_STARTFLOW.equals((Object)split)) {
                splitNode = template.getNodeSplitNodeID(splitNode);
                split = template.getNodeType(splitNode);
            }
            if (ProcessConstants.NodeType.NT_STARTFLOW.equals((Object)split)) {
                URI affectedElements = ProcessElementIdentifierTools.getConstraintEdgeIdentifier(checkReport.getBase(), start, destination);
                this.addReportEntry(CheckReport.ResultType.FAILURE, "Constraint edge contradicts control flow!", affectedElements);
                return false;
            }
        }
        return true;
    }
}

