/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Set;
import java.util.logging.Logger;

public class KF1Check
implements ProcessTemplateCheck {
    private static final String KF1CHECK_ID = "Structural check 1";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean everythingIsOK = true;
        if (template.getStartNode() == null) {
            String message = "Template '" + template.getName() + "' with ID '" + template.getID() + "' has no start node.";
            if (checkReport != null) {
                checkReport.addReportEntry(KF1CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            this.logger.severe(message);
            return false;
        }
        int startNodeID = template.getStartNode().getID();
        Set<StructuredEdge> edges = template.getEdgeStructure(new ProcessConstants.EdgeType[0]);
        boolean foundEdgeFromStart = false;
        for (StructuredEdge edge : edges) {
            String message;
            if (edge.getDestinationNodeID() == startNodeID) {
                message = "Template '" + template.getName() + "' with ID '" + template.getID() + "' has a start node with an incoming edge.";
                if (checkReport != null) {
                    checkReport.addReportEntry(KF1CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
                }
                this.logger.severe(message);
                everythingIsOK = false;
            }
            if (edge.getSourceNodeID() != startNodeID) continue;
            if (foundEdgeFromStart) {
                message = "Template '" + template.getName() + "' with ID '" + template.getID() + "' has multiple outgoing edges from the start node.";
                if (checkReport != null) {
                    checkReport.addReportEntry(KF1CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
                }
                this.logger.severe(message);
                everythingIsOK = false;
                continue;
            }
            if (!edge.getEdgeType().equals((Object)ProcessConstants.EdgeType.ET_CONTROL)) {
                message = "Template '" + template.getName() + "' with ID '" + template.getID() + "' has an outgoing non-control edge from the start node.";
                if (checkReport != null) {
                    checkReport.addReportEntry(KF1CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
                }
                this.logger.severe(message);
                everythingIsOK = false;
                continue;
            }
            foundEdgeFromStart = true;
        }
        if (!foundEdgeFromStart) {
            String message = "Template '" + template.getName() + "' with ID '" + template.getID() + "' has no outgoing control edge from the start node.";
            if (checkReport != null) {
                checkReport.addReportEntry(KF1CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            this.logger.severe(message);
            everythingIsOK = false;
        }
        return everythingIsOK;
    }
}

