/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class KF2Check
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Structural check 2";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean everythingIsOK = true;
        for (Node node : template.getNodes()) {
            URI[] affectedElements;
            String message;
            if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW) || template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) continue;
            int nodeID = node.getID();
            int[] preds = template.getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
            int[] succs = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
            if (preds.length == 0) {
                message = "The node '" + node.getName() + "' with ID '" + nodeID + "' has no predecessors.";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                everythingIsOK = false;
            }
            if (succs.length != 0) continue;
            message = "The node '" + node.getName() + "' with ID '" + nodeID + "' has no successors.";
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            everythingIsOK = false;
        }
        return everythingIsOK;
    }
}

