/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class KF3Check
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Structural check 3";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean everythingIsOK = true;
        Set<Integer> splitNodes = ProcessGraphPredicates.splitNodes(template);
        for (int s : splitNodes) {
            Object joinNodes;
            URI[] affectedElements;
            Set<Integer> allZ = ProcessGraphPredicates.c_succ(template, s);
            int join_s = ProcessGraphPredicates.join(template, s);
            for (int z : allZ) {
                Set<Integer> c_succ_trans_z = ProcessGraphPredicates.c_succ_trans(template, z);
                if (join_s == z || c_succ_trans_z.contains(join_s)) continue;
                String message = "KF3Check: Condition (1) not met (s in SplitNodes => for all z in c_succ(s): (join(s) in c_succ*(z)) OR (join(s) = z)).";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(s))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                everythingIsOK = false;
            }
            Set<Integer> c_succ_s = ProcessGraphPredicates.c_succ(template, s);
            if (c_succ_s.size() > 1) {
                Set<Integer> c_pred_trans_join_s = ProcessGraphPredicates.c_pred_trans(template, join_s);
                joinNodes = ProcessGraphPredicates.joinNodes(template);
                affectedElements = joinNodes.iterator();
                while (affectedElements.hasNext()) {
                    int j = (Integer)affectedElements.next();
                    if (!c_pred_trans_join_s.contains(j)) continue;
                    boolean zExists = false;
                    for (int z : ProcessGraphPredicates.c_succ(template, s)) {
                        if (j == z || ProcessGraphPredicates.c_succ_trans(template, z).contains(j)) continue;
                        zExists = true;
                        break;
                    }
                    if (zExists) continue;
                    String message = "Condition (2) not met.";
                    if (checkReport != null) {
                        URI[] affectedElements2 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(s)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(j))};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements2);
                    }
                    this.logger.severe(message);
                    everythingIsOK = false;
                }
            }
            joinNodes = splitNodes.iterator();
            while (joinNodes.hasNext()) {
                int s2 = (Integer)joinNodes.next();
                if (s == s2) continue;
                HashSet<Integer> Z = new HashSet<Integer>(ProcessGraphPredicates.c_succ_trans(template, s));
                Set<Integer> c_pred_trans_join_s = ProcessGraphPredicates.c_pred_trans(template, join_s);
                Iterator zI = Z.iterator();
                while (zI.hasNext()) {
                    int next = (Integer)zI.next();
                    if (c_pred_trans_join_s.contains(next)) continue;
                    zI.remove();
                }
                boolean s2InZ = Z.contains(s2);
                boolean joinS2InZ = Z.contains(ProcessGraphPredicates.join(template, s2));
                if (s2InZ && joinS2InZ || !joinS2InZ && !s2InZ) continue;
                String message = "Condition (3) not met.";
                if (checkReport != null) {
                    URI[] affectedElements3 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(s)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(s2))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements3);
                }
                this.logger.severe(message);
                everythingIsOK = false;
            }
            if (!template.getNodeType(s).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || template.getNodeType(join_s).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) continue;
            String message = "Condition (4) not met: s is an OR split, but join(s) is not an OR join!";
            if (checkReport != null) {
                URI[] affectedElements4 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(s)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(join_s))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements4);
            }
            this.logger.severe(message);
            everythingIsOK = false;
        }
        return everythingIsOK;
    }
}

