/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;

public class KF4Check
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Structural check 4";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean everythingOK = true;
        for (Node node : template.getNodes()) {
            Set<Integer> c_pred_trans_n;
            int n = node.getID();
            Set<Integer> c_succ_trans_n = ProcessGraphPredicates.c_succ_trans(template, n);
            if (c_succ_trans_n.contains(n)) {
                String message = "Template is cyclic, node '" + node.getName() + "' with ID '" + n + "' is in the set of its own transitive successors.";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                everythingOK = false;
            }
            if (!(c_pred_trans_n = ProcessGraphPredicates.c_pred_trans(template, n)).contains(n)) continue;
            String message = "Template is cyclic, node '" + node.getName() + "' with ID '" + n + "' is in the set of its own transitive predecessors.";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            everythingOK = false;
        }
        return everythingOK;
    }
}

