/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;

public class KF5Check
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Structural check 5";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        Set<StructuredEdge> syncEdges = template.getEdgeStructure(ProcessConstants.EdgeType.ET_SYNC);
        for (StructuredEdge edge : syncEdges) {
            URI[] affectedElements;
            String message;
            int[] branchNodes = ProcessGraphPredicates.branchNodes(template, edge.getSourceNodeID(), edge.getDestinationNodeID());
            if (branchNodes[0] == Integer.MIN_VALUE || branchNodes[1] == Integer.MIN_VALUE) {
                message = "Could not find branch nodes for source '" + edge.getSourceNodeID() + "' and destination '" + edge.getDestinationNodeID() + "'.";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(edge.getSourceNodeID()), template.getNode(edge.getDestinationNodeID()), edge.getEdgeType())};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            if (!template.getNodeType(branchNodes[0]).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT)) {
                message = "The split branch node (ID: '" + branchNodes[0] + "') is not an AND split.";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getBranchIdentifier(checkReport.getBase(), template.getNode(branchNodes[0]), template.getNode(branchNodes[1]))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            if (template.getNodeType(branchNodes[1]).equals((Object)ProcessConstants.NodeType.NT_AND_JOIN)) continue;
            message = "The split branch node (ID: '" + branchNodes[1] + "') is not an AND join.";
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getBranchIdentifier(checkReport.getBase(), template.getNode(branchNodes[0]), template.getNode(branchNodes[1]))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        return allOK;
    }
}

