/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.structure;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class KF7Check
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Structural check 7";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        HashSet<Integer> loopStartNodes = new HashSet<Integer>();
        HashSet<Integer> loopEndNodes = new HashSet<Integer>();
        HashMap<Integer, Set<Integer>> startNodeToBody = new HashMap<Integer, Set<Integer>>();
        for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            if (template.getNodeType(nodeID).equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
                loopStartNodes.add(nodeID);
                startNodeToBody.put(nodeID, ProcessGraphPredicates.loopBody(template, nodeID));
                continue;
            }
            if (!template.getNodeType(nodeID).equals((Object)ProcessConstants.NodeType.NT_ENDLOOP)) continue;
            loopEndNodes.add(nodeID);
        }
        Iterator<Object> iterator = loopStartNodes.iterator();
        while (iterator.hasNext()) {
            URI[] affectedElements;
            String message;
            int ls = (Integer)((Object)iterator.next());
            Set lsBody = (Set)startNodeToBody.get(ls);
            int le = ProcessGraphPredicates.endloop(template, ls);
            if (!ProcessGraphPredicates.c_succ_trans(template, ls).contains(le)) {
                String message2 = "The endloop '" + le + "' of '" + ls + "' is not in the set of transitive successors following control edges.";
                if (checkReport != null) {
                    Iterator<Integer> affectedElements2 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(ls)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(le))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, (URI)((Object)affectedElements2));
                }
                this.logger.severe(message2);
                allOK = false;
            }
            for (int s : ProcessGraphPredicates.splitNodes(template)) {
                int join_s = ProcessGraphPredicates.join(template, s);
                if ((!lsBody.contains(s) || lsBody.contains(join_s)) && (!lsBody.contains(join_s) || lsBody.contains(s))) continue;
                message = "Found a pair of block nodes ('" + s + "' and '" + join_s + "') - one inside the loop body of '" + ls + "' - one outside of it.";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(ls)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(s)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(join_s))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            for (int ls_ : loopStartNodes) {
                if (ls == ls_) continue;
                int ls_endloop = ProcessGraphPredicates.endloop(template, ls_);
                if ((!lsBody.contains(ls_) || lsBody.contains(ls_endloop)) && (!lsBody.contains(ls_endloop) || lsBody.contains(ls_))) continue;
                message = "Found a pair of loop nodes ('" + ls_ + "' and '" + ls_endloop + "') - one inside the loop body of '" + ls + "' - one outside of it.";
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(ls)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(ls_)), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(ls_endloop))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
        }
        for (StructuredEdge e : template.getEdgeStructure(ProcessConstants.EdgeType.ET_LOOP)) {
            if (loopEndNodes.contains(e.getSourceNodeID()) && loopStartNodes.contains(e.getDestinationNodeID())) continue;
            String message = "The source node of the edge is not coming from a loop end node; or the destination node of the edge is not going to a loop start node.";
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(e.getSourceNodeID()), template.getNode(e.getDestinationNodeID()), e.getEdgeType())};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            this.logger.severe(message);
            allOK = false;
        }
        for (StructuredEdge e : template.getEdgeStructure(ProcessConstants.EdgeType.ET_SYNC)) {
            for (Set body : startNodeToBody.values()) {
                int sourceNodeID = e.getSourceNodeID();
                int destinationNodeID = e.getDestinationNodeID();
                if ((!body.contains(sourceNodeID) || body.contains(destinationNodeID)) && (!body.contains(destinationNodeID) || body.contains(sourceNodeID))) continue;
                String message = "Source and destination node of the sync edge are not in the same loop block.";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(sourceNodeID), template.getNode(destinationNodeID), e.getEdgeType())};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
        }
        return allOK;
    }
}

