/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.BootstrapRegistry;
import de.aristaflow.adept2.base.registry.FileConfigurationManager;
import de.aristaflow.adept2.base.registry.InstanceToInstanceRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.ClientService;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.net.URI;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="Components.ClientService", type=Property.Type.STRING, isRequired=true, description="a required sub-registry for the client registry"), @Property(name="This.InstanceName", type=Property.Type.STRING, isRequired=true, description="The instance name for a server or a client."), @Property(name="SecurityManager", type=Property.Type.STRING, defaultValue="OrgModelManager", description="The security manager (instance of organisational model manager) to use for authentication.")})
public final class ClientBootstrap
extends BootstrapRegistry {
    @Deprecated
    private Registry registry = null;

    protected ClientBootstrap() throws ConfigurationException {
        super(ClientBootstrap.getRootConfigurationManager().getRootConfiguration(), ClientBootstrap.resolveInstanceName(ClientBootstrap.getRootConfigurationManager().getRootConfiguration()));
    }

    protected ClientBootstrap(Configuration rootConfiguration) throws ConfigurationException {
        super(rootConfiguration, ClientBootstrap.resolveInstanceName(rootConfiguration));
    }

    @Override
    protected void bootstrap() throws AbortServiceException {
        URI uri = ClientBootstrap.resolveURI();
        if (uri == null) {
            super.bootstrap();
        } else {
            super.bootstrap(uri);
        }
    }

    protected static String resolveInstanceName(Configuration configuration) throws ConfigurationException {
        String ret;
        try {
            ret = configuration.getString("This.InstanceName");
        }
        catch (IllegalArgumentException iae) {
            String msg = "An instance name must be provided for a client. Provide one via '%s=<instanceName>' in the root-configuration.";
            msg = String.format(msg, "This.InstanceName");
            throw new ConfigurationException(msg, iae);
        }
        return ret;
    }

    protected static URI resolveURI() {
        URI ret = null;
        try {
            ret = ConfigurationTools.parseURI(ClientBootstrap.getRootConfigurationManager().getRootConfiguration(), "This.URI");
        }
        catch (ConfigurationException configurationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return ret;
    }

    public static synchronized ClientBootstrap load() throws AbortServiceException {
        ClientBootstrap ret = new ClientBootstrap();
        ret.bootstrap();
        return ret;
    }

    public static synchronized ClientBootstrap load(Configuration rootConfiguration) throws AbortServiceException {
        rootConfigurationManager = FileConfigurationManager.initialiseConfigurationManager(rootConfiguration);
        ClientBootstrap ret = new ClientBootstrap(rootConfiguration);
        ret.bootstrap();
        return ret;
    }

    @Deprecated
    public static synchronized ClientBootstrap load(ConfigurationManager<?> confMgr) throws AbortServiceException {
        if (rootConfigurationManager != confMgr) {
            String msg = "Cannot bootstrap with another configuration manager than the already created root configuration manager. Please provide the root configuration manager which is the first created configuration manager.";
            throw new AbortServiceException(msg);
        }
        ClientBootstrap ret = new ClientBootstrap();
        ret.bootstrap();
        return ret;
    }

    @Deprecated
    public static ConfigurationManager<?> getConfigurationManager() throws ConfigurationException {
        return BootstrapRegistry.getRootConfigurationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        Class<BootstrapRegistry> clazz = BootstrapRegistry.class;
        synchronized (BootstrapRegistry.class) {
            if (bootstrapRegistry != null) {
                bootstrapRegistry.shutdown();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void prepareSecurityManager() throws ServiceNotKnownException {
        String simpleServiceName = this.configuration.getString("SecurityManager");
        String securityManagerServiceName = ClientBootstrap.getHierarchicalInstanceName("OrgModelManager", simpleServiceName);
        try {
            this.securityManager = this.getService(this.sessionFactory.getSessionToken(this.getURIs()), securityManagerServiceName, OrgModelManager.class).getSecurityManager();
        }
        catch (ServiceNotKnownException snke) {
            String msg = "The security manager could not be prepared but it is crucial for running the client. Aborting start!";
            this.logger.log(Level.SEVERE, msg, snke);
            throw snke;
        }
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ClientService getClientService() throws ServiceNotKnownException {
        return this.getServiceForInstance(this.sessionFactory.getSessionToken(this.getURIs()), ClientBootstrap.getHierarchicalInstanceName(this.instanceName, this.instanceName), "ClientService", ADEPT2ClientService.class);
    }

    @Deprecated
    public synchronized Registry getRegistry() throws ServiceNotKnownException {
        if (this.registry == null) {
            InstanceToInstanceRegistry mfRegistry = this.getRegistry(this.sessionFactory.getSessionToken(this.getURIs()), "ModelFactoryRegistry", InstanceToInstanceRegistry.class);
            this.registry = this.createRegistryWrapper(this.getInstanceName(), mfRegistry, (ModelViewerProvider)((Object)mfRegistry));
        }
        return this.registry;
    }
}

