/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.util.ArgChecks;

public class ClientQA {
    protected final QualifiedAgent agent;

    public ClientQA(QualifiedAgent agent) {
        ArgChecks.checkForNull(agent, "agent");
        this.agent = agent;
    }

    public QualifiedAgent getAgent() {
        return this.agent;
    }

    public String toString() {
        String ret;
        if (this.agent.getUserSessionID() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Agent: ");
            sb.append(this.agent.toString());
            sb.append(", User-Session-ID: ");
            sb.append(this.agent.getUserSessionID());
            ret = sb.toString();
        } else {
            ret = this.agent.toString();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        QualifiedAgent otherAgent;
        if (obj instanceof ClientQA) {
            otherAgent = ((ClientQA)obj).getAgent();
        } else if (obj instanceof QualifiedAgent) {
            otherAgent = (QualifiedAgent)obj;
        } else {
            return false;
        }
        boolean ret = this.agent.equals(otherAgent);
        if (ret) {
            ret = this.agent.getUserSessionID() != null ? this.agent.getUserSessionID().equals(otherAgent.getUserSessionID()) : otherAgent.getUserSessionID() == null;
        }
        return ret;
    }

    public int hashCode() {
        int hashCode = this.agent.hashCode();
        if (this.agent.getUserSessionID() != null) {
            hashCode ^= this.agent.getUserSessionID().hashCode();
        }
        return hashCode;
    }
}

