/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.security.Authentication;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.ClientService;
import de.aristaflow.adept2.core.client.SelectedGUIElementChangedEvent;
import de.aristaflow.adept2.core.client.SelectedGUIElementChangedListener;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceChanging;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.inittab.InitTabManager;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.processimagerenderer.ProcessImageRenderer;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIManager;
import de.aristaflow.adept2.core.runtimemanager.gui.RemoteGUIManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.graphical.GraphicalModelFactory;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironmentFactory;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;

public abstract class MultiplexingClientService
extends AbstractADEPT2Service
implements ADEPT2ClientService {
    protected final Map<String, ADEPT2ClientService> sessionServiceMapping;
    protected final Configuration configuration;
    protected ExecutorService executorService;

    public MultiplexingClientService(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"RuntimeManager"}, new String[0]);
        this.configuration = configuration;
        this.sessionServiceMapping = new HashMap<String, ADEPT2ClientService>();
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs, -2, -2, "password");
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("ClientServiceExecution"));
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.signalStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.signalShutdown(false);
        super.shutdown();
        this.executorService.shutdown();
        MultiplexingClientService multiplexingClientService = this;
        synchronized (multiplexingClientService) {
            Set<String> sessionIDs = this.sessionServiceMapping.keySet();
            String[] stringArray = sessionIDs.toArray(new String[sessionIDs.size()]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sessionID = stringArray[n2];
                this.removeSession(sessionID, false);
                ++n2;
            }
        }
        this.awaitExecutorServiceShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emergencyShutdown() {
        this.signalShutdown(true);
        super.emergencyShutdown();
        this.executorService.shutdownNow();
        MultiplexingClientService multiplexingClientService = this;
        synchronized (multiplexingClientService) {
            Set<String> sessionIDs = this.sessionServiceMapping.keySet();
            String[] stringArray = sessionIDs.toArray(new String[sessionIDs.size()]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sessionID = stringArray[n2];
                this.removeSession(sessionID, true);
                ++n2;
            }
        }
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Locale[] getAvailableLocales() {
        return new Locale[]{Locale.GERMANY, Locale.FRANCE, Locale.ITALY, Locale.UK, Locale.US};
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean isOnline() {
        return this.getClientService().isOnline();
    }

    @Override
    public boolean connect() {
        return this.getClientService().connect();
    }

    @Override
    public void disconnect() {
        this.getClientService().disconnect();
    }

    @Override
    public synchronized void logoff() {
        this.removeSession(this.getUserSessionID(), false);
    }

    @Override
    public SessionToken getSessionToken() {
        return this.getClientService().getSessionToken();
    }

    @Override
    public synchronized SessionToken getSessionToken(Map<String, String> additionalAttributes) {
        return this.getClientService().getSessionToken(additionalAttributes);
    }

    @Override
    public SessionToken getSessionToken(QualifiedAgent agent) {
        return this.getClientService().getSessionToken(agent);
    }

    @Override
    public synchronized SessionToken getSessionToken(QualifiedAgent agent, Map<String, String> additionalAttributes) {
        return this.getClientService().getSessionToken(agent, additionalAttributes);
    }

    @Override
    public FilterFactory getFilterFactory() {
        return this.getClientService().getFilterFactory();
    }

    @Override
    public GraphicalModelFactory getGraphicalModelFactory() {
        return this.getClientService().getGraphicalModelFactory();
    }

    @Override
    public synchronized void setAuthenticatedAgents(ClientSessionFactory[] clientSessionFactories) {
        ADEPT2ClientService clientService = this.getClientService();
        try {
            String sessionID = this.getUserSessionID();
            if (clientService == null) {
                SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
                clientService = this.registry.getConfiguredPlugin(session, this, "InnerClientService", ADEPT2ClientService.class);
                clientService.init(this.getURIs());
                clientService.start();
                this.sessionServiceMapping.put(sessionID, clientService);
            }
            clientService.setAuthenticatedAgents(clientSessionFactories);
        }
        catch (AbortServiceException ase) {
            throw new InternalServiceException("Unable to create user-specific client service or GUI manager. Aborting.", ase);
        }
    }

    @Override
    public RichAgent[] getAuthenticatedAgents() {
        return this.getClientService().getAuthenticatedAgents();
    }

    @Override
    public RichAgent getActiveAgent() {
        return this.getClientService().getActiveAgent();
    }

    @Override
    public void setActiveAgent(QualifiedAgent activeAgent) {
        this.getClientService().setActiveAgent(activeAgent);
    }

    @Override
    public void addActiveAgentListener(ClientService.ActiveAgentListener listener) {
        this.getClientService().addActiveAgentListener(listener);
    }

    @Override
    public void removeActiveAgentListener(ClientService.ActiveAgentListener listener) {
        this.getClientService().removeActiveAgentListener(listener);
    }

    @Override
    public void guiSelectionChanged(SelectedGUIElementChangedEvent selectionChangeEvent) {
        this.getClientService().guiSelectionChanged(selectionChangeEvent);
    }

    @Override
    public void addListener(SelectedGUIElementChangedListener selectedElementChangedListener) {
        this.getClientService().addListener(selectedElementChangedListener);
    }

    @Override
    public void removeListener(SelectedGUIElementChangedListener selectedElementChangedListener) {
        this.getClientService().removeListener(selectedElementChangedListener);
    }

    @Override
    public UpdateManager getUpdateManager() {
        return this.getClientService().getUpdateManager();
    }

    @Override
    public Authentication getAuthentication() {
        return this.registry.getSecurityManager();
    }

    @Override
    public LicenceManager getLicenceManager() throws ServiceNotKnownException {
        SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
        return this.registry.getServiceOfType(session, "LicenceManager", LicenceManager.class);
    }

    @Override
    public ActivityModelFactory getActivityModelFactory() {
        return this.getClientService().getActivityModelFactory();
    }

    @Override
    public ProcessModelFactory getProcessModelFactory() {
        return this.getClientService().getProcessModelFactory();
    }

    @Override
    public ExecutionFactory getExecutionFactory() {
        return this.getClientService().getExecutionFactory();
    }

    @Override
    public WorklistModelFactory getWorklistModelFactory() {
        return this.getClientService().getWorklistModelFactory();
    }

    @Override
    public ProcessCheckService getProcessChecks() {
        return this.getClientService().getProcessChecks();
    }

    @Override
    public ActivityRepository getActivityRepository() {
        return this.getClientService().getActivityRepository();
    }

    @Override
    public ProcessManager getProcessManager() {
        return this.getClientService().getProcessManager();
    }

    @Override
    public ProcessImageRenderer getProcessImageRenderer() {
        return this.getClientService().getProcessImageRenderer();
    }

    @Override
    public ProcessManager getProcessManager(UUID instanceID) {
        return this.getClientService().getProcessManager(instanceID);
    }

    @Override
    public ProcessRepository getProcessRepository() {
        return this.getClientService().getProcessRepository();
    }

    @Override
    public OrgModelManager getOrgModelManager() {
        return this.getClientService().getOrgModelManager();
    }

    @Override
    public ExecutionManager getExecutionManager() {
        return this.getClientService().getExecutionManager();
    }

    @Override
    public ExecutionManager getExecutionManagerForActivity(EBPInstanceReference ebpInstanceReference) {
        return this.getClientService().getExecutionManagerForActivity(ebpInstanceReference);
    }

    @Override
    public InstanceControl getInstanceControl() {
        return this.getClientService().getInstanceControl();
    }

    @Override
    public ActivityStarting getActivityStarting(EBPInstanceReference activity) {
        return this.getClientService().getActivityStarting(activity);
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting(EBPInstanceReference activity) {
        return this.getClientService().getSynchronousActivityStarting(activity);
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting(ADEPT2EBPReference activity) throws ServiceNotKnownException {
        return this.getClientService().getSynchronousActivityStarting(activity);
    }

    @Override
    public boolean executeRemotely(EBPInstanceReference activity) {
        return this.getClientService().executeRemotely(activity);
    }

    @Override
    public RemoteGUIManager getRemoteGUIManager() throws ServiceNotKnownException {
        return this.getClientService().getRemoteGUIManager();
    }

    @Override
    public InstanceChanging getInstanceChanging() {
        return this.getClientService().getInstanceChanging();
    }

    @Override
    public ExecutionHistory getExecutionHistory() {
        return this.getClientService().getExecutionHistory();
    }

    @Override
    public InitTabManager getInitTabManager() {
        return this.getClientService().getInitTabManager();
    }

    @Override
    public WorklistManager getWorklistManager() {
        return this.getClientService().getWorklistManager();
    }

    @Override
    public RuntimeEnvironmentFactory getRuntimeEnvironmentFactory() {
        return this.getClientService().getRuntimeEnvironmentFactory();
    }

    @Override
    public RuntimeManager getRuntimeManager() {
        return this.getClientService().getRuntimeManager();
    }

    @Override
    public SessionToken getRuntimeManagerSessionToken() {
        return this.getClientService().getRuntimeManagerSessionToken();
    }

    @Override
    public ExecutionControlManager getExecutionControlManager(EBPInstanceReference activity) {
        return this.getClientService().getExecutionControlManager(activity);
    }

    @Override
    public GUIManager getGUIManager() {
        return this.getClientService().getGUIManager();
    }

    @Override
    public Class<?> getModelViewerClass(String pluginID) {
        return this.registry.getModelViewerClass(pluginID);
    }

    @Override
    public <T extends ADEPT2Service> T getService(SessionToken session, URI[] serviceURIs, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getService(session, serviceURIs, serviceType);
    }

    @Override
    public <T extends ADEPT2Service> T getServiceOfType(SessionToken session, String typeName, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getServiceOfType(session, typeName, serviceType);
    }

    public ADEPT2ClientService getClientService() {
        return this.sessionServiceMapping.get(this.getUserSessionID());
    }

    public ADEPT2ClientService getClientService(SessionToken session) {
        QualifiedAgent agent;
        try {
            agent = this.sessionFactory.checkAndGetAgent(session);
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new InternalServiceException("Unable to retrieve session ID from designated session. Aborting.", stie);
        }
        return this.sessionServiceMapping.get(agent.getUserSessionID());
    }

    protected synchronized void removeSession(String sessionID, boolean emergency) {
        ADEPT2ClientService clientService = this.sessionServiceMapping.get(sessionID);
        if (clientService != null) {
            if (emergency) {
                clientService.emergencyShutdown();
            } else {
                clientService.shutdown();
            }
            this.sessionServiceMapping.remove(sessionID);
        }
    }

    protected abstract String getUserSessionID();
}

