/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation;

import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.core.client.RemoteClient;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractRemoteClient
implements RemoteClient {
    protected boolean isAvailable = true;
    protected List<RichAgent> loggedOnAgents = new ArrayList<RichAgent>();
    protected List<Locale> usedLocales = new ArrayList<Locale>();
    protected List<URI[]> runtimeManagerURIs = new ArrayList<URI[]>();

    public void shutdown() {
        this.isAvailable = false;
    }

    public synchronized void loggedOn(RichAgent agent, URI[] runtimeManager) {
        int index = this.loggedOnAgents.indexOf(agent);
        if (index < 0) {
            this.loggedOnAgents.add(agent);
            this.usedLocales.add(agent.getLocale());
            this.runtimeManagerURIs.add(runtimeManager);
        } else {
            this.runtimeManagerURIs.add(index, runtimeManager);
        }
    }

    public synchronized void setLocale(RichAgent agent, Locale usedLocale) {
        int index = this.loggedOnAgents.indexOf(agent);
        if (index >= 0) {
            this.usedLocales.add(index, usedLocale);
        }
    }

    public synchronized void loggedOff(RichAgent agent) {
        int index = this.loggedOnAgents.indexOf(agent);
        if (index >= 0) {
            this.loggedOnAgents.remove(index);
            this.usedLocales.remove(index);
            this.runtimeManagerURIs.remove(index);
        }
    }

    @Override
    public boolean ping() {
        return this.isAvailable;
    }

    @Override
    public String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getOperatingSystemVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public String getOperatingSystemArchitecture() {
        return System.getProperty("os.arch");
    }

    @Override
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    public Locale getUsedLocale(RichAgent agent) {
        Locale ret = agent.getLocale();
        int index = this.loggedOnAgents.indexOf(agent);
        if (index >= 0) {
            ret = this.usedLocales.get(index);
        }
        return ret;
    }

    @Override
    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    @Override
    public String getDefaultCharset() {
        return Charset.defaultCharset().name();
    }

    @Override
    public RichAgent[] getLoggedOnAgents() {
        return this.loggedOnAgents.toArray(new RichAgent[this.loggedOnAgents.size()]);
    }

    @Override
    public URI[][] getRuntimeManagerURIs() {
        return (URI[][])this.runtimeManagerURIs.toArray();
    }
}

