/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.core.worklistmanager.DelegationManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistAdministration;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistUpdateManager;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class BulkLogoffWorklistManager
implements WorklistManager {
    protected final WorklistManager worklistManager;
    protected final Map<SignedSecurityToken, UUID> logons;
    protected final Map<SignedSecurityToken, Boolean> logoffs;

    public BulkLogoffWorklistManager(WorklistManager worklistManager) {
        this.worklistManager = worklistManager;
        this.logons = new HashMap<SignedSecurityToken, UUID>();
        this.logoffs = new HashMap<SignedSecurityToken, Boolean>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoffAll(ClientSessionFactory[] sessionFactories) {
        ClientSessionFactory[] clientSessionFactoryArray = sessionFactories;
        int n = sessionFactories.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionFactory sessionFactory = clientSessionFactoryArray[n2];
            SessionToken session = sessionFactory.getSessionToken();
            Map<SignedSecurityToken, UUID> map = this.logons;
            synchronized (map) {
                if (this.logons.containsKey(session.getSecurityToken())) {
                    Boolean longterm = this.logoffs.get(session.getSecurityToken());
                    try {
                        this.worklistManager.logoff(session, longterm != null ? longterm : false);
                    }
                    catch (ServiceConnectionException e) {
                        String msg = "A ServiceConnectionException occurred while logging off from the worklist manager. Maybe the server is currently not available. Ignoring!";
                        LoggerTools.getLogger(this).log(Level.INFO, msg, e);
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID logon(SessionToken session) {
        UUID ret;
        Map<SignedSecurityToken, UUID> map = this.logons;
        synchronized (map) {
            if (!this.logons.containsKey(session.getSecurityToken())) {
                ret = this.worklistManager.logon(session);
                this.logons.put(session.getSecurityToken(), ret);
            } else {
                ret = this.logons.get(session.getSecurityToken());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logoff(SessionToken session, boolean longterm) {
        Map<SignedSecurityToken, UUID> map = this.logons;
        synchronized (map) {
            this.logoffs.put(session.getSecurityToken(), longterm);
        }
    }

    @Override
    public Map<String, String> getWorklistConfiguration(SessionToken session, UUID worklistID) {
        return this.worklistManager.getWorklistConfiguration(session, worklistID);
    }

    @Override
    public void setWorklistConfiguration(SessionToken session, UUID worklistID, Map<String, String> worklistConfiguration) {
        this.worklistManager.setWorklistConfiguration(session, worklistID, worklistConfiguration);
    }

    @Override
    public WorklistUpdateManager getWorklistUpdateManager() {
        return this.worklistManager.getWorklistUpdateManager();
    }

    @Override
    public DelegationManager getDelegationManager() {
        return this.worklistManager.getDelegationManager();
    }

    @Override
    public WorklistAdministration getAdministration() {
        return this.worklistManager.getAdministration();
    }

    @Override
    public URI[] getOrgModelManager(SessionToken session) {
        return this.worklistManager.getOrgModelManager(session);
    }

    @Override
    public boolean ping() {
        return this.worklistManager.ping();
    }

    @Override
    public String[] getStartupRequiredServices() {
        return this.worklistManager.getStartupRequiredServices();
    }

    @Override
    public String[] getRuntimeRequiredServices() {
        return this.worklistManager.getRuntimeRequiredServices();
    }

    @Override
    public void init(URI[] exportedURIs) {
    }

    @Override
    public URI[] getURIs() {
        return this.worklistManager.getURIs();
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void emergencyShutdown() {
    }
}

