/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.implementation.RuntimeLessClientService;
import de.aristaflow.adept2.core.client.implementation.WrappingActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import org.apache.commons.configuration.Configuration;

public class DefaultADEPT2ClientService
extends RuntimeLessClientService {
    protected RuntimeManager runtimeManager;

    @Deprecated
    public DefaultADEPT2ClientService(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"RuntimeManager"}, new String[0]);
    }

    @Deprecated
    public DefaultADEPT2ClientService(Configuration configuration, ADEPT2ClientService multiplexingCS, Registry registry) {
        this(configuration, registry);
    }

    protected synchronized void logoffAllFromRuntimeManager() {
        if (this.clientSessionFactories != null && this.runtimeManager != null) {
            ClientSessionFactory[] clientSessionFactoryArray = this.clientSessionFactories;
            int n = this.clientSessionFactories.length;
            int n2 = 0;
            while (n2 < n) {
                ClientSessionFactory factory = clientSessionFactoryArray[n2];
                QualifiedAgent agent = factory.getAuthenticatedAgent().getQualifiedAgent();
                this.runtimeManager.logoffAndTerminateActivities(factory.getSessionToken(), agent, true);
                ++n2;
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        super.disconnect();
        this.logoffAllFromRuntimeManager();
    }

    @Override
    public synchronized void setAuthenticatedAgents(ClientSessionFactory[] clientSessionFactories) {
        super.setAuthenticatedAgents(clientSessionFactories);
        try {
            this.runtimeManager = this.getRuntimeManager();
            ClientSessionFactory[] clientSessionFactoryArray = clientSessionFactories;
            int n = clientSessionFactories.length;
            int n2 = 0;
            while (n2 < n) {
                ClientSessionFactory factory = clientSessionFactoryArray[n2];
                this.runtimeManager.logon(factory.getSessionToken(), factory);
                ++n2;
            }
        }
        catch (RTServiceNotKnownException rTServiceNotKnownException) {}
    }

    @Override
    public ActivityStarting getActivityStarting(EBPInstanceReference activity) {
        ActivityStarting act = super.getActivityStarting(activity);
        return new WrappingActivityStarting(act, this.runtimeManager.getURIs());
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting(EBPInstanceReference activity) {
        SynchronousActivityStarting ret = this.runtimeManager.getSynchronousActivityStarting();
        if (ret == null) {
            String msg = "The runtime manager did not provide a synchronous activity starting. Please make sure, a runtime manager is configured and not a runtime service!";
            throw new InternalServiceException(msg);
        }
        return ret;
    }
}

