/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLConstants;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLExport;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLImport;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.FileSuffixFilter;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PersistingActivityTermination
extends AbstractSubService
implements ActivityTermination {
    private static final byte FINISHED = 0;
    private static final byte SUSPENDED = 1;
    private static final byte RESET = 2;
    private static final byte FAILED = 3;
    protected final Registry registry;
    protected SessionFactory sessionFactory;
    protected final File dir;
    protected final ExecutorService terminator;
    protected final Object unpersistorSync;
    protected UnpersistCall unpersistor;

    public PersistingActivityTermination(AbstractADEPT2Service service, Registry registry, boolean persisting) throws ConfigurationException {
        super(service);
        this.registry = registry;
        this.dir = persisting ? this.getDir() : null;
        this.terminator = Executors.newCachedThreadPool(new Adept2ThreadFactory("PersistedActivityTerminator", this.logger));
        this.unpersistorSync = new Object();
        this.unpersistor = null;
    }

    public void init(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void start() throws AbortServiceException {
        if (this.dir != null) {
            this.checkPersistedCalls();
        }
    }

    @Override
    public void shutdown() {
        this.terminator.shutdown();
        ExecutorTools.awaitTermination(this.terminator);
    }

    @Override
    public void emergencyShutdown() {
        this.terminator.shutdownNow();
        ExecutorTools.awaitTermination(this.terminator);
    }

    protected File getDir() throws ConfigurationException {
        String datadir = SystemProperties.getDataDir();
        File ret = new File(datadir, "ClientPersistence");
        try {
            boolean success;
            if (!ret.exists() && !(success = ret.mkdirs())) {
                String msg = "The client persistence directory '%s' could not be created and does not exist yet either!";
                throw new ConfigurationException(String.format(msg, ret));
            }
        }
        catch (SecurityException securityException) {
            String msg = "The client persistence directory '%s' could not be accessed and  does not exist yet either!";
            throw new ConfigurationException(String.format(msg, ret));
        }
        return ret;
    }

    protected ActivityTermination getActivityTermination(SessionToken session, EBPInstanceReference activity, boolean persisted) {
        ActivityTermination ret;
        block3: {
            ret = null;
            try {
                ret = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityTermination();
            }
            catch (ServiceNotKnownException snke) {
                if (persisted) break block3;
                if (this.dir == null) {
                    String msg = "Could not signal the termination of activity '%s' since the corresponding execution manager could not be retrieved, possibly due to a misconfiguration.";
                    throw new InternalServiceException(String.format(msg, activity), snke);
                }
                String msg = "Could not signal the termination of activity '%s' since the corresponding execution manager could not be retrieved, possibly due to a misconfiguration. Persisting the signal and retrying it later.";
                this.logger.log(Level.INFO, String.format(msg, activity), snke);
            }
        }
        return ret;
    }

    @Override
    public void activityFinished(SessionToken session, EBPInstanceReference activity, DataContainer dataContainer) throws InvalidActivityStateException {
        boolean successful = false;
        ActivityTermination at = this.getActivityTermination(session, activity, false);
        if (at == null) {
            this.persistCall((byte)0, session.getSecurityToken(), activity, dataContainer, null, null, Long.MIN_VALUE, System.currentTimeMillis());
        } else {
            try {
                at.activityFinished(session, activity, dataContainer);
                successful = true;
            }
            catch (ServiceConnectionException sce) {
                if (this.dir == null) {
                    throw sce;
                }
                String msg = "Could not signal activity '%s' finished since no connection could be established to the corresponding execution manager '%s'. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, sce);
                this.persistCall((byte)0, session.getSecurityToken(), activity, dataContainer, null, null, Long.MIN_VALUE, System.currentTimeMillis());
            }
            catch (InvalidServiceStateException isse) {
                if (this.dir == null) {
                    throw isse;
                }
                String msg = "Could not signal activity '%s' finished since the execution manager '%s' is shutting down. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, isse);
                this.persistCall((byte)0, session.getSecurityToken(), activity, dataContainer, null, null, Long.MIN_VALUE, System.currentTimeMillis());
            }
        }
        if (successful && this.dir != null) {
            this.checkPersistedCalls();
        }
    }

    @Override
    public void activitySuspended(SessionToken session, EBPInstanceReference activity, DataContainer dataContainer) throws InvalidActivityStateException {
        boolean successful = false;
        ActivityTermination at = this.getActivityTermination(session, activity, false);
        if (at == null) {
            this.persistCall((byte)1, session.getSecurityToken(), activity, dataContainer, null, null, Long.MIN_VALUE, System.currentTimeMillis());
        } else {
            try {
                at.activitySuspended(session, activity, dataContainer);
                successful = true;
            }
            catch (ServiceConnectionException sce) {
                if (this.dir == null) {
                    throw sce;
                }
                String msg = "Could not signal activity '%s' suspended since no connection could be established to the corresponding execution manager '%s'. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, sce);
                this.persistCall((byte)1, session.getSecurityToken(), activity, dataContainer, null, null, Long.MIN_VALUE, System.currentTimeMillis());
            }
            catch (InvalidServiceStateException isse) {
                if (this.dir == null) {
                    throw isse;
                }
                String msg = "Could not signal activity '%s' suspended since the execution manager '%s' is shutting down. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, isse);
                this.persistCall((byte)1, session.getSecurityToken(), activity, dataContainer, null, null, Long.MIN_VALUE, System.currentTimeMillis());
            }
        }
        if (successful && this.dir != null) {
            this.checkPersistedCalls();
        }
    }

    @Override
    public void activityReset(SessionToken session, EBPInstanceReference activity) throws InvalidActivityStateException {
        boolean successful = false;
        ActivityTermination at = this.getActivityTermination(session, activity, false);
        if (at == null) {
            this.persistCall((byte)2, session.getSecurityToken(), activity, null, null, null, Long.MIN_VALUE, System.currentTimeMillis());
        } else {
            try {
                at.activityReset(session, activity);
                successful = true;
            }
            catch (ServiceConnectionException sce) {
                if (this.dir == null) {
                    throw sce;
                }
                String msg = "Could not signal activity '%s' reset since no connection could be established to the corresponding execution manager '%s'. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, sce);
                this.persistCall((byte)2, session.getSecurityToken(), activity, null, null, null, Long.MIN_VALUE, System.currentTimeMillis());
            }
            catch (InvalidServiceStateException isse) {
                if (this.dir == null) {
                    throw isse;
                }
                String msg = "Could not signal activity '%s' reset since the execution manager '%s' is shutting down. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, isse);
                this.persistCall((byte)2, session.getSecurityToken(), activity, null, null, null, Long.MIN_VALUE, System.currentTimeMillis());
            }
        }
        if (successful && this.dir != null) {
            this.checkPersistedCalls();
        }
    }

    @Override
    public void activityFailed(SessionToken session, EBPInstanceReference activity, DataContainer dataContainer, String errorMessage, String state, long errorCode) throws InvalidActivityStateException {
        boolean successful = false;
        ActivityTermination at = this.getActivityTermination(session, activity, false);
        if (at == null) {
            this.persistCall((byte)3, session.getSecurityToken(), activity, dataContainer, errorMessage, state, errorCode, System.currentTimeMillis());
        } else {
            try {
                at.activityFailed(session, activity, dataContainer, errorMessage, state, errorCode);
                successful = true;
            }
            catch (ServiceConnectionException sce) {
                if (this.dir == null) {
                    throw sce;
                }
                String msg = "Could not signal activity '%s' failed since no connection could be established to the corresponding execution manager '%s'. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, sce);
                this.persistCall((byte)3, session.getSecurityToken(), activity, dataContainer, errorMessage, state, errorCode, System.currentTimeMillis());
            }
            catch (InvalidServiceStateException isse) {
                if (this.dir == null) {
                    throw isse;
                }
                String msg = "Could not signal activity '%s' failed since the execution manager '%s' is shutting down. Persisting the signal and retrying it later.";
                msg = String.format(msg, activity, Arrays.toString(activity.getExecutionManagerURIs()));
                this.logger.log(Level.INFO, msg, isse);
                this.persistCall((byte)3, session.getSecurityToken(), activity, dataContainer, errorMessage, state, errorCode, System.currentTimeMillis());
            }
        }
        if (successful && this.dir != null) {
            this.checkPersistedCalls();
        }
    }

    protected void persistCall(byte type, SignedSecurityToken securityToken, EBPInstanceReference activity, DataContainer dataContainer, String errorMessage, String state, long errorCode, long terminationTime) {
        StringBuilder builder = new StringBuilder();
        builder.append(activity.getInstanceID());
        builder.append("_");
        builder.append(activity.getNodeID());
        builder.append("_");
        builder.append(activity.getNodeIteration());
        builder.append(".xml");
        String filename = builder.toString();
        Document doc = ClientPersistenceXMLExport.getDocumentForClientPersistence(type, securityToken, activity, dataContainer, errorMessage, state, errorCode, terminationTime);
        try {
            Schema schema = ClientPersistenceXMLConstants.getClientPersistenceSchema();
            XMLHelperTools.writeDocumentToFile(doc, new File(this.dir, filename), schema);
        }
        catch (IOException ioe) {
            String msg = "An IOException occurred while trying to persist an activity termination call for activity '%s'!";
            msg = String.format(msg, activity);
            throw new InternalServiceException(msg, ioe);
        }
        catch (SAXException saxe) {
            String msg = "A SAXException occurred while trying to persist an activity termination call for activity '%s'!";
            msg = String.format(msg, activity);
            throw new InternalServiceException(msg, saxe);
        }
        catch (XMLFormatException xfe) {
            String msg = "An XMLFormatException occurred while trying to persist an activity termination call for activity '%s'!";
            msg = String.format(msg, activity);
            throw new InternalServiceException(msg, xfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistedCalls() {
        Object object = this.unpersistorSync;
        synchronized (object) {
            if (this.unpersistor == null) {
                this.unpersistor = new UnpersistCall();
                this.terminator.submit(this.unpersistor);
            }
        }
    }

    protected class UnpersistCall
    implements Runnable {
        protected UnpersistCall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File[] fileArray = PersistingActivityTermination.this.dir.listFiles(new FileSuffixFilter(".xml"));
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block29: {
                        SessionToken session;
                        ProcessModelFactory factory;
                        String msg;
                        Document doc;
                        File f = fileArray[n2];
                        SessionToken callerSession = PersistingActivityTermination.this.sessionFactory.getSessionToken(PersistingActivityTermination.this.getURIs());
                        try {
                            Schema schema = ClientPersistenceXMLConstants.getClientPersistenceSchema();
                            doc = XMLHelperTools.getDocumentFromFile(f, schema, null);
                        }
                        catch (FileNotFoundException fnfe) {
                            msg = "Cannot retrieve file '%s' containing a persisted termination. Retrying later.";
                            PersistingActivityTermination.this.logger.log(Level.INFO, String.format(msg, f), fnfe);
                            break block29;
                        }
                        catch (XMLFormatException xmlfe) {
                            msg = "Cannot read the file '%s' containing a persisted termination. Ignoring file and retrying later.";
                            PersistingActivityTermination.this.logger.log(Level.INFO, String.format(msg, f), xmlfe);
                            break block29;
                        }
                        catch (IOException ioe) {
                            msg = "Cannot read the file '%s' containing a persisted termination. Ignoring file and retrying later.";
                            PersistingActivityTermination.this.logger.log(Level.INFO, String.format(msg, f), ioe);
                            break block29;
                        }
                        catch (SAXException saxe) {
                            msg = "Cannot parse the file '%s' containing a persisted termination. Ignoring file and retrying later.";
                            PersistingActivityTermination.this.logger.log(Level.INFO, String.format(msg, f), saxe);
                            break block29;
                        }
                        try {
                            factory = PersistingActivityTermination.this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
                        }
                        catch (ServiceNotKnownException snke) {
                            msg = "Cannot retrieve the process model factory for unpersisting the activity termination call in file '%s'. Retrying later.";
                            PersistingActivityTermination.this.logger.log(Level.INFO, String.format(msg, f), snke);
                            break;
                        }
                        ClientPersistenceXMLConstants.ClientPersistence persistence = ClientPersistenceXMLImport.getClientPersistenceFromDocument(doc, factory);
                        EBPInstanceReference activity = persistence.getActivity();
                        DataContainer dataContainer = persistence.getDataContainer();
                        try {
                            HashMap<String, String> attributes = new HashMap<String, String>();
                            long delay = 0L;
                            long currentTime = System.currentTimeMillis();
                            if (currentTime > persistence.getTerminationTime()) {
                                delay = currentTime - persistence.getTerminationTime();
                            }
                            attributes.put("TerminationSignalDelay", Long.toString(delay));
                            session = PersistingActivityTermination.this.sessionFactory.getSubstituteSessionToken(callerSession, persistence.getToken(), attributes);
                        }
                        catch (SecurityTokenIntegrityException stie) {
                            msg = "Cannot retrieve a substitute session token for processing persisted termination of activity '%s'. Retrying later.";
                            PersistingActivityTermination.this.logger.log(Level.INFO, String.format(msg, activity), stie);
                            break;
                        }
                        ActivityTermination at = PersistingActivityTermination.this.getActivityTermination(session, activity, true);
                        if (at != null) {
                            try {
                                switch (persistence.getType()) {
                                    case 0: {
                                        at.activityFinished(session, activity, dataContainer);
                                        break;
                                    }
                                    case 1: {
                                        at.activitySuspended(session, activity, dataContainer);
                                        break;
                                    }
                                    case 2: {
                                        at.activityReset(session, activity);
                                        break;
                                    }
                                    case 3: {
                                        at.activityFailed(session, activity, dataContainer, persistence.getErrorMessage(), persistence.getState(), persistence.getErrorCode());
                                        break;
                                    }
                                    default: {
                                        msg = "The activity '%s' has the unknown activity termination type '%s'. Deleting persisted data.";
                                        msg = String.format(msg, activity, persistence.getType());
                                        PersistingActivityTermination.this.logger.warning(msg);
                                        break;
                                    }
                                }
                            }
                            catch (InvalidActivityStateException iase) {
                                msg = "An InvalidActivityStateException occurred while trying to retry the persisted activity termination call for activity %s. Probably the activity has been reset or executed otherwise.";
                                msg = String.format(msg, activity);
                                PersistingActivityTermination.this.logger.log(Level.INFO, msg, iase);
                            }
                            boolean deleted = f.delete();
                            if (!deleted) {
                                msg = "The client persistence file '%s' for activity '%s' could not be deleted! The activity termination call may be processed again, probably failing with an InvalidActivityStateException.";
                                msg = String.format(msg, f, activity);
                                PersistingActivityTermination.this.logger.severe(msg);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Object object = PersistingActivityTermination.this.unpersistorSync;
                synchronized (object) {
                    PersistingActivityTermination.this.unpersistor = null;
                }
                throw throwable;
            }
            Object object = PersistingActivityTermination.this.unpersistorSync;
            synchronized (object) {
                PersistingActivityTermination.this.unpersistor = null;
            }
        }
    }
}

