/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteRuntimeManager {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Registry registry;
    protected final Map<String, RuntimeManager> remoteRuntimeManager;
    protected final Map<String, List<ClientSessionFactory>> loggedOnRemRtMgr;

    public RemoteRuntimeManager(Registry registry) {
        this.registry = registry;
        this.remoteRuntimeManager = new HashMap<String, RuntimeManager>();
        this.loggedOnRemRtMgr = new HashMap<String, List<ClientSessionFactory>>();
    }

    public synchronized RuntimeManager getLoggedOnRemoteRuntimeManager(String name, ClientSessionFactory csf) throws ServiceNotKnownException {
        List<ClientSessionFactory> loggedOn;
        boolean retrieve;
        RuntimeManager ret = null;
        if (this.remoteRuntimeManager.containsKey(name)) {
            ret = this.remoteRuntimeManager.get(name);
            try {
                ret.ping();
                retrieve = false;
            }
            catch (ServiceConnectionException sce) {
                String msg = "Cannot connect to the previously known runtime manager '%s'. Trying to reconnect and log on again.";
                msg = String.format(msg, name);
                this.logger.log(Level.FINE, msg, sce);
                retrieve = true;
                this.loggedOnRemRtMgr.remove(name);
            }
        } else {
            retrieve = true;
        }
        if (retrieve) {
            SessionToken session = csf.getSessionToken();
            String rtName = AbstractRegistry.getHierarchicalInstanceName("RuntimeManager", name);
            ret = this.registry.getService(session, rtName, RuntimeManager.class);
            this.remoteRuntimeManager.put(name, ret);
        }
        if (!this.loggedOnRemRtMgr.containsKey(name)) {
            this.loggedOnRemRtMgr.put(name, new ArrayList(4));
        }
        if (!(loggedOn = this.loggedOnRemRtMgr.get(name)).contains(csf)) {
            ret.logon(csf.getSessionToken(), csf);
            loggedOn.add(csf);
        }
        return ret;
    }

    public synchronized void logoff(ClientSessionFactory csf, boolean forceTermination) {
        for (Map.Entry<String, List<ClientSessionFactory>> loggedOn : this.loggedOnRemRtMgr.entrySet()) {
            if (!loggedOn.getValue().contains(csf)) continue;
            String name = loggedOn.getKey();
            RuntimeManager rtMgr = this.remoteRuntimeManager.get(name);
            try {
                rtMgr.logoffAndTerminateActivities(csf.getSessionToken(), csf.getAuthenticatedAgent().getQualifiedAgent(), forceTermination);
            }
            catch (RuntimeException re) {
                QualifiedAgent agent = csf.getAuthenticatedAgent().getQualifiedAgent();
                String msg = "There were problems logging off agent '%s' from runtime manager '%s' ('%s'). Continuing with logging off.";
                msg = String.format(msg, agent, name, Arrays.toString(rtMgr.getURIs()));
                this.logger.log(Level.INFO, msg, re);
            }
        }
    }

    public synchronized void disconnectAll() {
        for (Map.Entry<String, RuntimeManager> rtMgrs : this.remoteRuntimeManager.entrySet()) {
            String name = rtMgrs.getKey();
            RuntimeManager rtMgr = rtMgrs.getValue();
            for (ClientSessionFactory csf : this.loggedOnRemRtMgr.get(name)) {
                try {
                    rtMgr.logoffAndTerminateActivities(csf.getSessionToken(), csf.getAuthenticatedAgent().getQualifiedAgent(), true);
                }
                catch (RuntimeException re) {
                    QualifiedAgent agent = csf.getAuthenticatedAgent().getQualifiedAgent();
                    String msg = "There were problems logging off agent '%s' from runtime manager '%s' ('%s'). Continuing with logging off.";
                    msg = String.format(msg, agent, name, Arrays.toString(rtMgr.getURIs()));
                    this.logger.log(Level.INFO, msg, re);
                }
            }
            this.loggedOnRemRtMgr.remove(name);
        }
        this.remoteRuntimeManager.clear();
    }
}

