/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.security.Authentication;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.ClientService;
import de.aristaflow.adept2.core.client.SelectedGUIElementChangedEvent;
import de.aristaflow.adept2.core.client.SelectedGUIElementChangedListener;
import de.aristaflow.adept2.core.client.implementation.BulkLogoffWorklistManager;
import de.aristaflow.adept2.core.client.implementation.RemoteRuntimeManager;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceChanging;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.inittab.InitTabManager;
import de.aristaflow.adept2.core.logmanager.LogManager;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.processimagerenderer.ProcessImageRenderer;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIManager;
import de.aristaflow.adept2.core.runtimemanager.gui.RemoteGUIManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.graphical.GraphicalModelFactory;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironmentFactory;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="SynchronousAgentChangedNotification", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether active agent changes are notified synchronously by the thread indicating the active agent change. Otherwise a separate executor service will forward the change to registered listeners."), @Property(name="SynchronousSelectionChangedNotification", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether selection changes are notified synchronously by the thread indicating the selection change. Otherwise a separate executor service will forward the change to registered listeners.")})
public class RuntimeLessClientService
extends AbstractADEPT2Service
implements ADEPT2ClientService {
    protected static final String CONF_SYNCHRONOUS_AGENT_CHANGED_NOTIFICATION = "SynchronousAgentChangedNotification";
    protected static final String CONF_SYNCHRONOUS_SELECTION_CHANGED_NOTIFICATION = "SynchronousSelectionChangedNotification";
    protected static final String CONF_REMOTE_RUNTIME_MANAGER_INSTANCE_PREFIX = "RemoteRuntimeManagerInstance";
    protected static final String CONF_GUI_CONTEXT_REM_RT_MGR_PREFIX = "GUIContextID";
    protected volatile ClientSessionFactory clientSessionFactory;
    protected final List<SelectedGUIElementChangedListener> selectionChangeListener = new LinkedList<SelectedGUIElementChangedListener>();
    protected final List<ClientService.ActiveAgentListener> agentListeners = new LinkedList<ClientService.ActiveAgentListener>();
    protected final ExecutorService guiNotifier;
    protected final ExecutorService activeAgentNotifier;
    protected ExecutorService executorService;
    protected ClientSessionFactory[] clientSessionFactories;
    protected BulkLogoffWorklistManager worklistManager;
    protected final Map<String, String> remoteRtMgrs;
    protected final RemoteRuntimeManager remoteRtMgr;
    protected boolean shutdown;

    @Deprecated
    public RuntimeLessClientService(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.remoteRtMgrs = Collections.unmodifiableMap(this.parseRemoteRtMgr(configuration));
        this.remoteRtMgr = new RemoteRuntimeManager(registry);
        this.shutdown = false;
        Adept2ThreadFactory tf = new Adept2ThreadFactory("ActiveAgentNotifier", this.logger);
        this.activeAgentNotifier = configuration.getBoolean(CONF_SYNCHRONOUS_AGENT_CHANGED_NOTIFICATION) ? null : Executors.newSingleThreadExecutor(tf);
        tf = new Adept2ThreadFactory("GUISelectionNotifier", this.logger);
        this.guiNotifier = configuration.getBoolean(CONF_SYNCHRONOUS_SELECTION_CHANGED_NOTIFICATION) ? null : Executors.newSingleThreadExecutor(tf);
    }

    @Deprecated
    protected RuntimeLessClientService(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        super(configuration, registry, startupRequiredServices, runtimeRequiredServices);
        this.remoteRtMgrs = Collections.unmodifiableMap(this.parseRemoteRtMgr(configuration));
        this.remoteRtMgr = new RemoteRuntimeManager(registry);
        this.shutdown = false;
        Adept2ThreadFactory tf = new Adept2ThreadFactory("ActiveAgentNotifier", this.logger);
        this.activeAgentNotifier = configuration.getBoolean(CONF_SYNCHRONOUS_AGENT_CHANGED_NOTIFICATION) ? null : Executors.newSingleThreadExecutor(tf);
        tf = new Adept2ThreadFactory("GUISelectionNotifier", this.logger);
        this.guiNotifier = configuration.getBoolean(CONF_SYNCHRONOUS_SELECTION_CHANGED_NOTIFICATION) ? null : Executors.newSingleThreadExecutor(tf);
    }

    @Deprecated
    public RuntimeLessClientService(Configuration configuration, ADEPT2ClientService multiplexingCS, Registry registry) {
        this(configuration, registry);
    }

    protected Map<String, String> parseRemoteRtMgr(Configuration configuration) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String prefix = String.format("%s.%s", CONF_REMOTE_RUNTIME_MANAGER_INSTANCE_PREFIX, CONF_GUI_CONTEXT_REM_RT_MGR_PREFIX);
        Configuration conf = configuration.subset(prefix);
        Iterator keys = conf.getKeys();
        while (keys.hasNext()) {
            String guiContextID = (String)keys.next();
            String instName = conf.getString(guiContextID);
            ret.put(guiContextID, instName);
        }
        return ret;
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("ClientServiceExecution", this.logger));
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.signalStart();
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.signalShutdown(false);
            this.logoff();
            super.shutdown();
            this.executorService.shutdown();
            if (this.guiNotifier != null) {
                this.guiNotifier.shutdown();
            }
            if (this.activeAgentNotifier != null) {
                this.activeAgentNotifier.shutdown();
            }
            ExecutorTools.awaitTermination(this.executorService);
            ExecutorTools.awaitTermination(this.guiNotifier);
            ExecutorTools.awaitTermination(this.activeAgentNotifier);
            this.shutdown = true;
        }
    }

    @Override
    public void emergencyShutdown() {
        if (!this.shutdown) {
            this.signalShutdown(true);
            this.logoff();
            super.emergencyShutdown();
            this.executorService.shutdownNow();
            if (this.guiNotifier != null) {
                this.guiNotifier.shutdownNow();
            }
            if (this.activeAgentNotifier != null) {
                this.activeAgentNotifier.shutdownNow();
            }
            ExecutorTools.awaitTermination(this.executorService);
            ExecutorTools.awaitTermination(this.guiNotifier);
            ExecutorTools.awaitTermination(this.activeAgentNotifier);
            this.shutdown = true;
        }
    }

    @Override
    public Locale[] getAvailableLocales() {
        return new Locale[]{Locale.GERMANY, Locale.FRANCE, Locale.ITALY, Locale.UK, Locale.US};
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean connect() {
        return true;
    }

    @Override
    public synchronized void disconnect() {
        if (this.worklistManager != null && this.clientSessionFactories != null) {
            this.worklistManager.logoffAll(this.clientSessionFactories);
        }
        this.remoteRtMgr.disconnectAll();
    }

    @Override
    public synchronized void logoff() {
        this.disconnect();
        if (this.clientSessionFactory != null) {
            this.changeActiveAgent(null, this.clientSessionFactory);
            this.clientSessionFactories = null;
            this.clientSessionFactory = null;
        }
    }

    @Override
    public synchronized SessionToken getSessionToken() {
        return this.getSessionToken((Map<String, String>)null);
    }

    @Override
    public synchronized SessionToken getSessionToken(Map<String, String> additionalAttributes) {
        return this.clientSessionFactory != null ? this.clientSessionFactory.getSessionToken(additionalAttributes) : null;
    }

    @Override
    public synchronized SessionToken getSessionToken(QualifiedAgent agent) {
        return this.getSessionToken(agent, null);
    }

    @Override
    public synchronized SessionToken getSessionToken(QualifiedAgent agent, Map<String, String> additionalAttributes) {
        ArgChecks.checkForNull(agent, "agent");
        ClientSessionFactory[] clientSessionFactoryArray = this.clientSessionFactories;
        int n = this.clientSessionFactories.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionFactory factory = clientSessionFactoryArray[n2];
            if (factory.getAuthenticatedAgent().getQualifiedAgent().equals(agent)) {
                return factory.getSessionToken(additionalAttributes);
            }
            ++n2;
        }
        String message = "The agent " + agent + " is not one of the authenticated agents";
        throw new IllegalArgumentException(message);
    }

    @Override
    public FilterFactory getFilterFactory() {
        try {
            return this.registry.getModelFactory("FilterFactory", FilterFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public GraphicalModelFactory getGraphicalModelFactory() {
        try {
            return this.registry.getModelFactory("GraphicalModelFactory", GraphicalModelFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public synchronized void setAuthenticatedAgents(ClientSessionFactory[] clientSessionFactories) {
        ArgChecks.checkForEmpty(clientSessionFactories, "clientSessionFactories");
        if (this.clientSessionFactories != null) {
            throw new ServiceAccessControlException("The authenticated agents have already been set.");
        }
        this.clientSessionFactories = (ClientSessionFactory[])clientSessionFactories.clone();
        ClientSessionFactory[] clientSessionFactoryArray = clientSessionFactories;
        int n = clientSessionFactories.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionFactory factory = clientSessionFactoryArray[n2];
            factory.setClientURIs(this.getURIs());
            ++n2;
        }
        this.clientSessionFactory = clientSessionFactories[0];
        QualifiedAgent activeAgent = this.clientSessionFactory.getAuthenticatedAgent().getQualifiedAgent();
        this.setActiveAgent(activeAgent);
    }

    @Override
    public synchronized RichAgent[] getAuthenticatedAgents() {
        RichAgent[] ret;
        if (this.clientSessionFactories != null) {
            ret = new RichAgent[this.clientSessionFactories.length];
            int i = 0;
            while (i < this.clientSessionFactories.length) {
                ret[i] = this.clientSessionFactories[i].getAuthenticatedAgent();
                ++i;
            }
        } else {
            ret = new RichAgent[]{};
        }
        return ret;
    }

    @Override
    public synchronized RichAgent getActiveAgent() {
        return this.clientSessionFactory != null ? this.clientSessionFactory.getAuthenticatedAgent() : null;
    }

    @Override
    public synchronized void setActiveAgent(QualifiedAgent activeAgent) {
        ArgChecks.checkForNull(activeAgent, "activeAgent");
        ClientSessionFactory[] clientSessionFactoryArray = this.clientSessionFactories;
        int n = this.clientSessionFactories.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionFactory factory = clientSessionFactoryArray[n2];
            if (factory.getAuthenticatedAgent().getQualifiedAgent().equals(activeAgent)) {
                this.clientSessionFactory = factory;
                this.changeActiveAgent(factory.getAuthenticatedAgent(), factory);
                return;
            }
            ++n2;
        }
        String message = "The agent " + activeAgent + " is not one of the authenticated agents";
        throw new ServiceAccessControlException(message);
    }

    private void changeActiveAgent(RichAgent agent, ClientSessionFactory factory) {
        ActiveAgentNotifierRunnable notification = new ActiveAgentNotifierRunnable(agent, factory, this.agentListeners);
        if (this.activeAgentNotifier != null) {
            this.activeAgentNotifier.execute(notification);
        } else {
            notification.run();
        }
    }

    @Override
    public void addActiveAgentListener(ClientService.ActiveAgentListener listener) {
        this.agentListeners.add(listener);
    }

    @Override
    public void removeActiveAgentListener(ClientService.ActiveAgentListener listener) {
        this.agentListeners.remove(listener);
    }

    @Override
    public void guiSelectionChanged(SelectedGUIElementChangedEvent selectionChangeEvent) {
        GuiNotifierRunnable notification = new GuiNotifierRunnable(selectionChangeEvent, this.selectionChangeListener);
        if (this.guiNotifier != null) {
            this.guiNotifier.execute(notification);
        } else {
            notification.run();
        }
    }

    @Override
    public void addListener(SelectedGUIElementChangedListener selectedElementChangedListener) {
        if (!this.selectionChangeListener.contains(selectedElementChangedListener)) {
            this.selectionChangeListener.add(selectedElementChangedListener);
        }
    }

    @Override
    public void removeListener(SelectedGUIElementChangedListener selectedElementChangedListener) {
        this.selectionChangeListener.remove(selectedElementChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateManager getUpdateManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "UpdateManager", UpdateManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public Authentication getAuthentication() {
        return this.registry.getSecurityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LicenceManager getLicenceManager() throws ServiceNotKnownException {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        SessionToken session = csf.getSessionToken();
        return this.registry.getServiceOfType(session, "LicenceManager", LicenceManager.class);
    }

    @Override
    public ActivityModelFactory getActivityModelFactory() {
        try {
            return this.registry.getModelFactory("ActivityModelFactory", ActivityModelFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public ProcessModelFactory getProcessModelFactory() {
        try {
            return this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public ExecutionFactory getExecutionFactory() {
        try {
            return this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public WorklistModelFactory getWorklistModelFactory() {
        try {
            return this.registry.getModelFactory("WorklistModelFactory", WorklistModelFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessCheckService getProcessChecks() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ProcessChecks", ProcessCheckService.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityRepository getActivityRepository() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ActivityRepository", ActivityRepository.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessManager getProcessManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ProcessManager", ProcessManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessManager getProcessManager(UUID instanceID) {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            ExecutionManager em = this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class);
            URI[] pmURIs = em.getProcessManager(session, instanceID);
            return this.getService(session, pmURIs, ProcessManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessImageRenderer getProcessImageRenderer() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ProcessImageRenderer", ProcessImageRenderer.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessRepository getProcessRepository() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ProcessRepository", ProcessRepository.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrgModelManager getOrgModelManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "OrgModelManager", OrgModelManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionManager getExecutionManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionManager getExecutionManagerForActivity(EBPInstanceReference ebpInstanceReference) {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            URI[] emURIs = ebpInstanceReference.getExecutionManagerURIs();
            return this.getService(session, emURIs, ExecutionManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceControl getInstanceControl() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class).getInstanceControl();
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityStarting getActivityStarting(EBPInstanceReference activity) {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            ActivityStarting act = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            return act;
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting(EBPInstanceReference activity) {
        String msg = "This client service does not have a runtime manager and therefore does not support SynchronousActivityStarting. Use another client service by adapting your configuration appropriately.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean executeRemotely(EBPInstanceReference activity) {
        boolean ret = activity instanceof ADEPT2EBPReference;
        if (ret) {
            String guiContextID = ((ADEPT2EBPReference)activity).getGUIContextID();
            ret = this.remoteRtMgrs.containsKey(guiContextID);
        }
        return ret;
    }

    @Override
    public RemoteGUIManager getRemoteGUIManager() throws ServiceNotKnownException {
        try {
            return (RemoteGUIManager)this.getGUIManager();
        }
        catch (ClassCastException cce) {
            throw new ServiceNotKnownException("RemoteGUIManager", (Throwable)cce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting(ADEPT2EBPReference activity) throws ServiceNotKnownException {
        SynchronousActivityStarting ret;
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        String guiContextID = activity.getGUIContextID();
        if (this.remoteRtMgrs.containsKey(guiContextID)) {
            String simpleName = this.remoteRtMgrs.get(guiContextID);
            RuntimeManager rtMgr = this.remoteRtMgr.getLoggedOnRemoteRuntimeManager(simpleName, csf);
            ret = rtMgr.getSynchronousActivityStarting();
        } else {
            ret = this.getSynchronousActivityStarting((EBPInstanceReference)activity);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceChanging getInstanceChanging() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class).getInstanceChanging();
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionHistory getExecutionHistory() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "LogManager", LogManager.class).getExecutionHistory();
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitTabManager getInitTabManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "InitTab", InitTabManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorklistManager getWorklistManager() {
        BulkLogoffWorklistManager ret;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            if (this.worklistManager == null) {
                if (this.clientSessionFactory == null) {
                    String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
                    throw new InvalidServiceStateException(msg);
                }
                try {
                    SessionToken session = this.clientSessionFactory.getSessionToken();
                    WorklistManager wlm = this.registry.getServiceOfType(session, "WorklistManager", WorklistManager.class);
                    this.worklistManager = new BulkLogoffWorklistManager(wlm);
                }
                catch (ServiceNotKnownException snke) {
                    throw new RTServiceNotKnownException(snke);
                }
            }
            ret = this.worklistManager;
        }
        return ret;
    }

    @Override
    public RuntimeEnvironmentFactory getRuntimeEnvironmentFactory() {
        try {
            return this.registry.getModelFactory("RuntimeEnvironmentFactory", RuntimeEnvironmentFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeManager getRuntimeManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "RuntimeManager", RuntimeManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionToken getRuntimeManagerSessionToken() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            RuntimeManager rm = this.registry.getServiceOfType(session, "RuntimeManager", RuntimeManager.class);
            return csf.getSessionToken(rm.getURIs());
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionControlManager getExecutionControlManager(EBPInstanceReference activity) {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.getService(session, activity.getRuntimeManagerURIs(), RuntimeManager.class).getExecutionControlManager();
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUIManager getGUIManager() {
        ClientSessionFactory csf;
        RuntimeLessClientService runtimeLessClientService = this;
        synchronized (runtimeLessClientService) {
            csf = this.clientSessionFactory;
        }
        if (csf == null) {
            String msg = "Currently no agent is logged on. Therefore no service can be retrieved.";
            throw new InvalidServiceStateException(msg);
        }
        try {
            SessionToken session = csf.getSessionToken();
            return this.registry.getServiceOfType(session, "GUIManager", GUIManager.class);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public Class<?> getModelViewerClass(String pluginID) {
        return this.registry.getModelViewerClass(pluginID);
    }

    @Override
    public <T extends ADEPT2Service> T getService(SessionToken session, URI[] serviceURIs, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getService(session, serviceURIs, serviceType);
    }

    @Override
    public <T extends ADEPT2Service> T getServiceOfType(SessionToken session, String typeName, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getServiceOfType(session, typeName, serviceType);
    }

    protected static class ActiveAgentNotifierRunnable
    implements Runnable {
        private final RichAgent agent;
        private final ClientSessionFactory factory;
        private final List<ClientService.ActiveAgentListener> listeners;

        ActiveAgentNotifierRunnable(RichAgent agent, ClientSessionFactory factory, List<ClientService.ActiveAgentListener> listeners) {
            this.agent = agent;
            this.factory = factory;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            ClientService.ActiveAgentListener[] activeAgentListenerArray = this.listeners.toArray(new ClientService.ActiveAgentListener[this.listeners.size()]);
            int n = activeAgentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientService.ActiveAgentListener listener = activeAgentListenerArray[n2];
                try {
                    listener.activeAgentChanged(this.agent, this.factory.getSessionToken());
                }
                catch (RuntimeException e) {
                    String message = "Caught an exception while informing an active agent listener";
                    LoggerTools.getLogger(this).log(Level.SEVERE, message, e);
                }
                ++n2;
            }
        }
    }

    protected static class GuiNotifierRunnable
    implements Runnable {
        private final SelectedGUIElementChangedEvent selectionChangeEvent;
        private final List<SelectedGUIElementChangedListener> listeners;

        GuiNotifierRunnable(SelectedGUIElementChangedEvent event, List<SelectedGUIElementChangedListener> listeners) {
            this.selectionChangeEvent = event;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            SelectedGUIElementChangedListener[] selectedGUIElementChangedListenerArray = this.listeners.toArray(new SelectedGUIElementChangedListener[this.listeners.size()]);
            int n = selectedGUIElementChangedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SelectedGUIElementChangedListener changeListener = selectedGUIElementChangedListenerArray[n2];
                changeListener.guiSelectionChanged(this.selectionChangeEvent);
                ++n2;
            }
        }
    }
}

