/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation.xml;

import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml.DataContainerXMLExport;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientPersistenceXMLExport {
    public static Document getDocumentForClientPersistence(byte type, SignedSecurityToken token, EBPInstanceReference activity, DataContainer dataContainer, String errorMessage, String state, long errorCode, long terminationTime) {
        Document doc = XMLHelperTools.createDocument();
        Element cpElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "clientPersistence");
        cpElement.setAttributeNS(null, "type", Byte.toString(type));
        Element tokenElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "token");
        tokenElement.setTextContent(Base64.encodeObject(token, 2));
        cpElement.appendChild(tokenElement);
        cpElement.appendChild(XMLExportTools.createEBPInstanceReferenceElement(doc, "http://www.aristaflow.de/adept2/clientpersistence", activity, true));
        if (dataContainer != null) {
            Element dcElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "dataContainer");
            DataContainerXMLExport.fillDataContainerElement(doc, dcElement, dataContainer, true);
            cpElement.appendChild(dcElement);
        }
        if (errorMessage != null) {
            Element errorMessageElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "errorMessage");
            errorMessageElement.setTextContent(errorMessage);
            cpElement.appendChild(errorMessageElement);
        }
        if (state != null) {
            Element stateElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "state");
            stateElement.setTextContent(state);
            cpElement.appendChild(stateElement);
        }
        if (errorCode != Long.MIN_VALUE) {
            Element errorCodeElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "errorCode");
            errorCodeElement.setTextContent(Long.toString(errorCode));
            cpElement.appendChild(errorCodeElement);
        }
        Element timeElement = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "terminationTime");
        timeElement.setTextContent(Long.toString(terminationTime));
        cpElement.appendChild(timeElement);
        doc.appendChild(cpElement);
        return doc;
    }

    public static Document getDocumentForAutomaticResumePersistence(Map<EBPInstanceReference, Long> automaticResume) {
        Document doc = XMLHelperTools.createDocument();
        Element persistence = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "persistence");
        for (Map.Entry<EBPInstanceReference, Long> entry : automaticResume.entrySet()) {
            Element ar = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "automaticResume");
            Element ebpIR = XMLExportTools.createEBPInstanceReferenceElement(doc, "http://www.aristaflow.de/adept2/clientpersistence", entry.getKey(), true);
            ar.appendChild(ebpIR);
            Element resumeTime = doc.createElementNS("http://www.aristaflow.de/adept2/clientpersistence", "resumeTime");
            resumeTime.setTextContent(Long.toString(entry.getValue()));
            ar.appendChild(resumeTime);
            persistence.appendChild(ar);
        }
        doc.appendChild(persistence);
        return doc;
    }
}

