/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.client.implementation.xml;

import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLConstants;
import de.aristaflow.adept2.model.common.XMLImportTools;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml.DataContainerXMLImport;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ClientPersistenceXMLImport {
    public static ClientPersistenceXMLConstants.ClientPersistence getClientPersistenceFromDocument(Document doc, ProcessModelFactory factory) {
        DataContainer dataContainer = null;
        String errorMessage = null;
        String state = null;
        long errorCode = Long.MIN_VALUE;
        long terminationTime = System.currentTimeMillis();
        Element root = doc.getDocumentElement();
        byte type = Byte.parseByte(root.getAttribute("type"));
        Element child = ClientPersistenceXMLImport.getElement(root.getFirstChild());
        SignedSecurityToken securityToken = (SignedSecurityToken)Base64.decodeToObject(child.getTextContent());
        child = ClientPersistenceXMLImport.getElement(child.getNextSibling());
        EBPInstanceReference activity = XMLImportTools.getEBPInstanceReference(child);
        child = ClientPersistenceXMLImport.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("dataContainer")) {
                dataContainer = DataContainerXMLImport.getDataContainerFromElement(child);
            } else if (child.getTagName().equals("errorMessage")) {
                errorMessage = child.getTextContent();
            } else if (child.getTagName().equals("state")) {
                state = child.getTextContent();
            } else if (child.getTagName().equals("errorCode")) {
                errorCode = Long.parseLong(child.getTextContent());
            } else if (child.getTagName().equals("terminationTime")) {
                terminationTime = Long.parseLong(child.getTextContent());
            }
            child = ClientPersistenceXMLImport.getElement(child.getNextSibling());
        }
        return new ClientPersistenceXMLConstants.ClientPersistence(type, securityToken, activity, dataContainer, errorMessage, state, errorCode, terminationTime);
    }

    public static Map<EBPInstanceReference, Long> getAutomaticResumePersistenceFromDocument(Document doc) {
        HashMap<EBPInstanceReference, Long> map = new HashMap<EBPInstanceReference, Long>();
        Element root = doc.getDocumentElement();
        Element child = ClientPersistenceXMLImport.getElement(root.getFirstChild());
        while (child != null) {
            Element innerChild = ClientPersistenceXMLImport.getElement(child.getFirstChild());
            EBPInstanceReference key = XMLImportTools.getEBPInstanceReference(innerChild);
            innerChild = ClientPersistenceXMLImport.getElement(innerChild.getNextSibling());
            Long value = Long.valueOf(innerChild.getTextContent());
            map.put(key, value);
            child = ClientPersistenceXMLImport.getElement(child.getNextSibling());
        }
        return map;
    }

    private static Element getElement(Node node) {
        return XMLHelperTools.getElement(node);
    }
}

