/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.abstractimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.complexeventmanager.EventFilter;
import de.aristaflow.adept2.core.complexeventmanager.EventListener;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.complexeventmanager.EventQueue;
import de.aristaflow.adept2.core.complexeventmanager.EventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventClassManager;
import de.aristaflow.adept2.model.eventmodel.EventDescription;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractEventSinkManager
extends AbstractADEPT2Service
implements EventSinkManager {
    protected Map<EventDescription, Map<EventListener, EventQueue>> listeners;
    protected final DefaultEventClassManager eventClassManager;

    public AbstractEventSinkManager(Configuration configuration, Registry registry, EventManager eventManager, DefaultEventClassManager eventTypeManager) {
        super(configuration, registry);
        this.eventClassManager = eventTypeManager;
        this.listeners = new HashMap<EventDescription, Map<EventListener, EventQueue>>();
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
    }

    @Override
    public void emergencyShutdown() {
        this.signalShutdown(true);
        super.emergencyShutdown();
    }

    @Override
    public void shutdown() {
        this.signalShutdown(false);
        super.shutdown();
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.signalStart();
    }

    @Override
    public void registerEventListener(EventListener listener) {
        if (listener instanceof EventFilter) {
            this.addEventListener(null, listener, (EventFilter)((Object)listener));
        } else {
            this.addEventListener(null, listener, null);
        }
    }

    @Override
    public void registerEventListener(EventListener listener, EventFilter filter) {
        this.addEventListener(null, listener, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventListener(EventDescription eventDescription, EventListener listener, EventFilter filter) {
        for (String eventType : listener.getConsumedEventClasses()) {
            if (this.eventClassManager.isSourceRegistered(eventType)) continue;
            this.logger.warning(String.format("Got Listener (%1$s) for Event Type %2$s but no Source registered!", listener, eventType));
        }
        Map<EventDescription, Map<EventListener, EventQueue>> map = this.listeners;
        synchronized (map) {
            EventQueue queue = this.createEventQueue(listener, filter);
            Map<EventListener, EventQueue> map2 = this.listeners.get(eventDescription);
            if (map2 == null) {
                map2 = new HashMap<EventListener, EventQueue>(5);
                this.listeners.put(eventDescription, map2);
            }
            map2.put(listener, queue);
        }
    }

    protected abstract EventQueue createEventQueue(EventListener var1, EventFilter var2);

    @Override
    public void deregisterEventListener(EventListener listener) {
        this.removeEventListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEventListener(EventDescription eventDescription, EventListener listener) {
        Map<EventDescription, Map<EventListener, EventQueue>> map = this.listeners;
        synchronized (map) {
            Map<EventListener, EventQueue> map2 = this.listeners.get(eventDescription);
            if (map2 != null) {
                EventQueue eventQueue = map2.remove(listener);
                eventQueue.shutdown();
                if (map2.size() == 0) {
                    this.listeners.remove(eventDescription);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EventQueue> getEventQueues(EventReference event) {
        HashSet<EventQueue> queues = new HashSet<EventQueue>();
        Map<EventDescription, Map<EventListener, EventQueue>> map = this.listeners;
        synchronized (map) {
            for (Map.Entry<EventDescription, Map<EventListener, EventQueue>> l : this.listeners.entrySet()) {
                if (l.getKey() == null) {
                    queues.addAll(l.getValue().values());
                    continue;
                }
                EventDescription eventDescription = l.getKey();
                if (!this.eventClassManager.isMatch(eventDescription, event)) continue;
                queues.addAll(l.getValue().values());
            }
        }
        return queues;
    }

    @Override
    public void deregisterFromEvent(EventListener listener, EventDescription event) {
        this.removeEventListener(event, listener);
    }

    @Override
    public void registerForEvent(EventListener listener, EventDescription event) {
        if (listener instanceof EventFilter) {
            this.addEventListener(event, listener, (EventFilter)((Object)listener));
        } else {
            this.addEventListener(event, listener, null);
        }
    }
}

