/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.abstractimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.complexeventmanager.EventListener;
import de.aristaflow.adept2.core.complexeventmanager.EventQueue;
import de.aristaflow.adept2.core.complexeventmanager.EventSource;
import de.aristaflow.adept2.core.complexeventmanager.EventSourceConfiguration;
import de.aristaflow.adept2.core.complexeventmanager.EventSourceManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventSource;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventSourceConfiguration;
import de.aristaflow.adept2.model.eventmodel.EventClass;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractEventSourceManager
extends AbstractADEPT2Service
implements EventSourceManager {
    private final DefaultEventManager defaultEventManager;
    protected Map<String, EventQueue> eventSources = new HashMap<String, EventQueue>();
    protected DefaultEventClassManager eventClassManager;

    public AbstractEventSourceManager(Configuration configuration, Registry registry, DefaultEventManager defaultEventManager, DefaultEventClassManager eventTypeManager) {
        super(configuration, registry, new String[0], new String[0]);
        this.defaultEventManager = defaultEventManager;
        this.eventClassManager = eventTypeManager;
    }

    @Override
    public void emergencyShutdown() {
        this.signalShutdown(true);
        super.emergencyShutdown();
    }

    @Override
    public void shutdown() {
        this.signalShutdown(false);
        super.shutdown();
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.signalStart();
    }

    @Override
    public EventSource createEventSource(String name, EventSourceConfiguration configuration) {
        HashSet<EventClass> clz = new HashSet<EventClass>();
        for (String eventClassID : configuration.getProducedEventClasses()) {
            if (!this.eventClassManager.isEventClassKnown(eventClassID)) {
                throw new IllegalArgumentException(String.format("EventSourceConfiguration invalid! EventType %s not known to EventTypeManager!", eventClassID));
            }
            clz.add(this.eventClassManager.getEventClass(eventClassID));
        }
        DefaultEventSource eventSource = new DefaultEventSource(name, clz, this.defaultEventManager.getEventModelFactory());
        return eventSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterEventSource(EventSource source) {
        boolean success;
        Map<String, EventQueue> map = this.eventSources;
        synchronized (map) {
            EventQueue queue = this.eventSources.remove(source.getID());
            boolean bl = success = queue != null;
            if (queue != null) {
                queue.shutdown();
            }
        }
        if (success) {
            this.eventClassManager.removeSource(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEventSource(EventSource source) {
        boolean success;
        this.logger.log(Level.INFO, String.format("Event Source %1$s registered!", source.getID()));
        Map<String, EventQueue> map = this.eventSources;
        synchronized (map) {
            EventListener listener = new EventListener(){

                @Override
                public Set<String> getConsumedEventClasses() {
                    return null;
                }

                @Override
                public void eventOccurred(EventReference event) {
                    AbstractEventSourceManager.this.raiseEvent(event);
                }
            };
            EventQueue eventQueue = this.createEventQueue(listener);
            EventQueue oldQueue = this.eventSources.put(source.getID(), eventQueue);
            boolean bl = success = oldQueue == null;
            if (oldQueue != null) {
                oldQueue.shutdown();
            }
            source.setEventQueue(eventQueue);
        }
        if (success) {
            this.eventClassManager.addSource(source);
        }
    }

    protected abstract EventQueue createEventQueue(EventListener var1);

    protected void raiseEvent(EventReference event) {
        if (!this.eventSources.containsKey(event.getSourceID())) {
            this.logger.severe(String.format("Event Source %1$s not registered dropping Event!", event.getSourceID()));
        }
        this.defaultEventManager.propagateEvent(event);
    }

    @Override
    public EventSourceConfiguration createEventSourceConfiguration(String ... eventClasses) {
        return new DefaultEventSourceConfiguration(eventClasses);
    }
}

