/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.complexeventmanager.EventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.EventSource;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventManager;
import de.aristaflow.adept2.model.eventmodel.EventAttributeMatcher;
import de.aristaflow.adept2.model.eventmodel.EventClass;
import de.aristaflow.adept2.model.eventmodel.EventDescription;
import de.aristaflow.adept2.model.eventmodel.EventModelFactory;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.model.eventmodel.defaultimplementation.DefaultEventClass;
import de.aristaflow.adept2.util.ArgChecks;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DefaultEventClassManager
extends AbstractADEPT2Service
implements EventClassManager {
    private static final String BASE_EVENT_ID = "de.aristaflow.adept2.model.eventmodel.BaseEvent";
    private final Map<String, EventClass> eventClasses = new HashMap<String, EventClass>();
    private final Map<String, String> parentClasses = new HashMap<String, String>();
    private final Map<String, Set<EventSource>> sources = new HashMap<String, Set<EventSource>>();
    private EventModelFactory eventModelFactory;

    public DefaultEventClassManager(Configuration configuration, Registry registry, DefaultEventManager defaultEventManager) {
        super(configuration, registry);
        this.eventModelFactory = defaultEventManager.getEventModelFactory();
        this.createBaseEvent();
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.signalShutdown(true);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.signalShutdown(false);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.signalStart();
    }

    private void createBaseEvent() {
        HashMap knownAttributes = new HashMap();
        DefaultEventClass eventClass = new DefaultEventClass(BASE_EVENT_ID, "Base Event", "Root Event of the Event hierarchy!", new ArrayList<String>(), knownAttributes);
        this.eventClasses.put(eventClass.getEventClassID(), eventClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventClass createAndRegisterEventClass(String eventClassID, String name, String description, Map<String, Class<?>> knownAttributes, String parentClassID) {
        String parentID;
        ArgChecks.checkForNull(eventClassID, "eventClassID");
        ArgChecks.checkForNull(name, "name");
        ArgChecks.checkForNull(knownAttributes, "knownAttributes");
        ArgChecks.checkForNulls(knownAttributes, "knownAttributes");
        if (this.isEventClassKnown(eventClassID)) {
            throw new IllegalArgumentException(String.format("Event Class '%1$s' already registered!", eventClassID));
        }
        if (parentClassID != null && parentClassID.length() > 0) {
            if (!this.isEventClassKnown(parentClassID)) {
                throw new IllegalArgumentException(String.format("Event Class '%1$s' unknown!", parentClassID));
            }
            parentID = parentClassID;
        } else {
            parentID = BASE_EVENT_ID;
        }
        List<String> classification = this.getEventClassHierarchy(parentID);
        EventClass eventClass = this.getEventModelFactory().createEventClass(eventClassID, name, description != null ? description : "", classification, knownAttributes);
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            this.eventClasses.put(eventClass.getEventClassID(), eventClass);
            this.parentClasses.put(eventClassID, parentID);
        }
        return eventClass;
    }

    protected EventModelFactory getEventModelFactory() {
        return this.eventModelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getEventClassHierarchy(String classID) {
        ArrayList<String> classification = new ArrayList<String>();
        String parentClassID = classID;
        while (parentClassID != null) {
            classification.add(parentClassID);
            Map<String, EventClass> map = this.eventClasses;
            synchronized (map) {
                parentClassID = this.parentClasses.get(parentClassID);
            }
        }
        return classification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getChildEventClasses(String classID) {
        HashSet<String> cls = new HashSet<String>();
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            for (Map.Entry<String, String> p : this.parentClasses.entrySet()) {
                if (!p.getValue().equals(classID)) continue;
                cls.add(p.getKey());
            }
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventClass getEventClass(String eventClassID) {
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            return this.eventClasses.get(eventClassID);
        }
    }

    @Override
    public EventClass getNearestEventClass(EventDescription eventDescription) {
        EventClass eventClass = this.getEventClass(eventDescription.getEventClassID());
        if (eventClass == null) {
            return null;
        }
        if (this.isMatch(eventDescription, eventClass)) {
            return eventClass;
        }
        LinkedList<String> childs = new LinkedList<String>();
        childs.addAll(this.getChildEventClasses(eventClass.getEventClassID()));
        while (!childs.isEmpty()) {
            String eventClassID = (String)childs.poll();
            eventClass = this.getEventClass(eventClassID);
            if (this.isMatch(eventDescription, eventClass)) {
                return eventClass;
            }
            childs.addAll(this.getChildEventClasses(eventClassID));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredEventClassIDs() {
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<String>(this.eventClasses.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<EventClass> getRegisteredEventClasses() {
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<EventClass>(this.eventClasses.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEventClassKnown(EventDescription eventDescription) {
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            EventClass e;
            Iterator<EventClass> iterator = this.eventClasses.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.isMatch(eventDescription, e = iterator.next()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEventClassKnown(String eventClassID) {
        ArgChecks.checkForNull(eventClassID, "eventClassID");
        Map<String, EventClass> map = this.eventClasses;
        synchronized (map) {
            return this.eventClasses.containsKey(eventClassID);
        }
    }

    @Override
    public boolean isMatch(EventDescription eventDescription, EventClass eventClass) {
        ArgChecks.checkForNull(eventDescription, "eventDescription");
        ArgChecks.checkForNull(eventClass, "eventClass");
        List<String> classification = this.getEventClassHierarchy(eventClass.getEventClassID());
        if (!classification.contains(eventDescription.getEventClassID())) {
            return false;
        }
        for (String attrib : eventDescription.getRequiredAttributes().keySet()) {
            if (eventClass.getAttributes().keySet().contains(attrib)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(EventDescription eventDescription, EventReference event) {
        ArgChecks.checkForNull(eventDescription, "eventDescription");
        ArgChecks.checkForNull(event, "event");
        EventClass eventClass = this.getEventClass(event.getEventClassID());
        if (this.isMatch(eventDescription, eventClass)) {
            return false;
        }
        for (Map.Entry<String, EventAttributeMatcher> a : eventDescription.getRequiredAttributes().entrySet()) {
            Object attribute = event.getAttribute(a.getKey());
            if (a.getValue().match(attribute)) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean isSubClassOf(String subClassID, String parentClassID) {
        if (this.isEventClassKnown(subClassID) && this.isEventClassKnown(parentClassID)) {
            String tmp = subClassID;
            do {
                if (!tmp.equals(parentClassID)) continue;
                return true;
            } while ((tmp = this.parentClasses.get(tmp)) != null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSource(String eventClassID, EventSource source) {
        Map<String, Set<EventSource>> map = this.sources;
        synchronized (map) {
            Set<EventSource> set = this.sources.get(eventClassID);
            if (set == null) {
                set = new HashSet<EventSource>();
                this.sources.put(eventClassID, set);
                this.logger.log(Level.INFO, String.format("Event Source %1$s registered as Source for Event Class %2$s", source.getID(), eventClassID));
            }
            set.add(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(EventSource source) {
        Map<String, Set<EventSource>> map = this.sources;
        synchronized (map) {
            for (EventClass eventClass : source.getProducedEventClasses()) {
                this.addSource(eventClass.getEventClassID(), source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSource(String eventClassID, EventSource source) {
        Map<String, Set<EventSource>> map = this.sources;
        synchronized (map) {
            Set<EventSource> set = this.sources.get(eventClassID);
            if (set != null) {
                set.remove(source);
                if (set.size() == 0) {
                    this.sources.remove(eventClassID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(EventSource source) {
        Map<String, Set<EventSource>> map = this.sources;
        synchronized (map) {
            for (EventClass eventClass : source.getProducedEventClasses()) {
                this.removeSource(eventClass.getEventClassID(), source);
            }
        }
    }

    @Override
    public boolean isSourceRegistered(EventClass eventClass) {
        return this.isSourceRegistered(eventClass.getEventClassID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSourceRegistered(String eventClassID) {
        Map<String, Set<EventSource>> map = this.sources;
        synchronized (map) {
            Set<EventSource> set = this.sources.get(eventClassID);
            return set != null && set.size() > 0;
        }
    }
}

