/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.complexeventmanager.EventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.complexeventmanager.EventQueue;
import de.aristaflow.adept2.core.complexeventmanager.EventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.EventSourceManager;
import de.aristaflow.adept2.core.complexeventmanager.abstractimplementation.AbstractEventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.abstractimplementation.AbstractEventSourceManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventSourceManager;
import de.aristaflow.adept2.model.eventmodel.EventModelFactory;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.model.eventmodel.defaultimplementation.DefaultEventModelFactory;
import java.net.URI;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DefaultEventManager
extends AbstractADEPT2Service
implements EventManager {
    protected AbstractEventSourceManager eventSourceManager;
    protected AbstractEventSinkManager eventSinkManager;
    protected DefaultEventClassManager eventClassManager;
    protected final Configuration configuration;
    protected DefaultEventModelFactory eventModelFactory;

    public DefaultEventManager(Configuration configuration, Registry registry) {
        this(configuration, registry, new String[0], new String[0]);
    }

    public DefaultEventManager(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        super(configuration, registry, startupRequiredServices, runtimeRequiredServices);
        this.configuration = configuration;
        this.logger.log(Level.INFO, "Event Manager initialized");
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.eventModelFactory = new DefaultEventModelFactory();
        this.eventClassManager = new DefaultEventClassManager(this.configuration, this.registry, this);
        this.eventSourceManager = new DefaultEventSourceManager(this.configuration, this.registry, this, this.eventClassManager);
        this.eventSinkManager = new DefaultEventSinkManager(this.configuration, this.registry, this, this.eventClassManager);
        this.eventClassManager.init(myURIs);
        this.eventSourceManager.init(myURIs);
        this.eventSinkManager.init(myURIs);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.eventClassManager.start();
        this.eventSourceManager.start();
        this.eventSinkManager.start();
    }

    @Override
    public void shutdown() {
        this.signalShutdown(false);
        this.eventClassManager.shutdown();
        this.eventSourceManager.shutdown();
        this.eventSinkManager.shutdown();
        super.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.signalShutdown(true);
        this.eventClassManager.emergencyShutdown();
        this.eventSourceManager.emergencyShutdown();
        this.eventSinkManager.emergencyShutdown();
        super.emergencyShutdown();
    }

    public void propagateEvent(EventReference event) {
        this.logger.log(Level.INFO, String.format("Event Received (%s))", event));
        Set<EventQueue> queues = this.eventSinkManager.getEventQueues(event);
        this.logger.fine(String.format("Distributing Event %2$d@%1$s to Event Queues", event.getEventID(), event.getEventNumber()));
        for (EventQueue queue : queues) {
            queue.queueEvent(event);
        }
        this.logger.fine(String.format("Finished distributing Event %2$d@%1$s to Event Queues", event.getEventID(), event.getEventNumber()));
    }

    @Override
    public EventSourceManager getEventSourceManager() {
        return this.eventSourceManager;
    }

    @Override
    public EventSinkManager getEventSinkManager() {
        return this.eventSinkManager;
    }

    @Override
    public EventClassManager getEventClassManager() {
        return this.eventClassManager;
    }

    public EventModelFactory getEventModelFactory() {
        return this.eventModelFactory;
    }
}

