/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.complexeventmanager.EventFilter;
import de.aristaflow.adept2.core.complexeventmanager.EventListener;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.complexeventmanager.EventQueue;
import de.aristaflow.adept2.core.complexeventmanager.EventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.abstractimplementation.AbstractEventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventQueue;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;

public class DefaultEventSinkManager
extends AbstractEventSinkManager
implements EventSinkManager {
    protected ExecutorService executorService;

    public DefaultEventSinkManager(Configuration configuration, Registry registry, EventManager eventManager, DefaultEventClassManager eventTypeManager) {
        super(configuration, registry, eventManager, eventTypeManager);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("EventSinkManager", this.logger));
    }

    @Override
    public void emergencyShutdown() {
        this.signalShutdown(true);
        this.executorService.shutdownNow();
        super.emergencyShutdown();
        this.awaitExecutorServiceShutdown();
    }

    @Override
    public void shutdown() {
        this.signalShutdown(false);
        this.executorService.shutdownNow();
        super.shutdown();
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.signalStart();
    }

    @Override
    protected EventQueue createEventQueue(EventListener listener, EventFilter filter) {
        DefaultEventQueue queue = new DefaultEventQueue(listener, filter);
        this.executorService.execute(queue);
        return queue;
    }
}

